/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import com.amazonaws.SdkClientException;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import java.time.Instant;
import java.time.Period;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.BackupClientBuilder;
import software.amazon.awssdk.services.backup.model.BackupJob;
import software.amazon.awssdk.services.backup.model.BackupJobState;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable;

public class BackupUtils {
    private static final Map<Region, BackupClient> CLIENTS = new ConcurrentHashMap<Region, BackupClient>();
    private static final Period HISTORY = Period.ofDays(45);

    public static List<BackupJob.Builder> listBackupJobs(String arn, Region region, MagpieAWSClientCreator clientCreator, Logger logger) {
        int retries = 5;
        while (retries > 0) {
            LinkedList<BackupJob.Builder> linkedList;
            block10: {
                LinkedList<BackupJob.Builder> jobs = new LinkedList<BackupJob.Builder>();
                BackupClient client = (BackupClient)((BackupClientBuilder)((BackupClientBuilder)clientCreator.apply(BackupClient.builder())).region(region)).build();
                try {
                    ListBackupJobsRequest.Builder builder = ListBackupJobsRequest.builder().byResourceArn(arn).byCreatedAfter(Instant.now().minus(HISTORY)).maxResults(Integer.valueOf(1000)).byState(BackupJobState.COMPLETED);
                    ListBackupJobsIterable result = client.listBackupJobsPaginator((ListBackupJobsRequest)builder.build());
                    result.forEach(response -> jobs.addAll(response.backupJobs().stream().map(BackupJob::toBuilder).collect(Collectors.toList())));
                    linkedList = jobs;
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SdkClientException ex) {
                        if (--retries == 0) {
                            throw ex;
                        }
                        logger.warn("Couldn't list backup jobs for {}, retrying {} more times", (Object)arn, (Object)retries);
                    }
                }
                client.close();
            }
            return linkedList;
        }
        return List.of();
    }
}

