/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.Conversions;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javatuples.Pair;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.RdsClientBuilder;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class RDSDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "rds";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return RdsClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (RdsClient client = (RdsClient)((RdsClientBuilder)clientCreator.apply(RdsClient.builder())).build();){
            this.discoverDbSnapshot(mapper, session, region, emitter, account, client);
            this.discoverDbInstances(mapper, session, region, emitter, logger, account, client, clientCreator);
        }
    }

    private void discoverDbSnapshot(ObjectMapper mapper, Session session, Region region, Emitter emitter, String account, RdsClient client) {
        String RESOURCE_TYPE = "AWS::RDS::DBSnapshot";
        try {
            client.describeDBSnapshots((DescribeDbSnapshotsRequest)DescribeDbSnapshotsRequest.builder().includeShared(Boolean.valueOf(true)).includePublic(Boolean.valueOf(false)).build()).dbSnapshots().forEach(snapshot -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, snapshot.dbSnapshotArn()).withResourceName(snapshot.dbSnapshotIdentifier()).withResourceId(snapshot.dbSnapshotArn()).withResourceType("AWS::RDS::DBSnapshot").withConfiguration(mapper.valueToTree((Object)snapshot.toBuilder())).withCreatedIso(snapshot.instanceCreateTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":dbSnapshot"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::RDS::DBSnapshot", null, region, (SdkException)ex);
        }
    }

    private void discoverDbInstances(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, RdsClient client, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::RDS::DBInstance";
        try {
            client.describeDBInstancesPaginator().dbInstances().stream().forEach(db -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, db.dbInstanceArn()).withResourceName(db.dbInstanceIdentifier()).withResourceId(db.dbInstanceArn()).withResourceType("AWS::RDS::DBInstance").withConfiguration(mapper.valueToTree((Object)db.toBuilder())).withCreatedIso(db.instanceCreateTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                if (db.instanceCreateTime() == null) {
                    logger.warn("DBInstance has NULL CreateTime: dbInstanceArn=\"{}\"", (Object)db.dbInstanceArn());
                }
                this.discoverTags(client, (DBInstance)db, data, mapper);
                this.discoverInstanceDbClusters(client, (DBInstance)db, data);
                this.discoverInstanceDbSnapshots(client, (DBInstance)db, data);
                this.discoverInstanceSize((DBInstance)db, data, logger, clientCreator);
                this.discoverBackupJobs(db.dbInstanceArn(), region, data, clientCreator);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":dbInstance"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::RDS::DBInstance", null, region, (SdkException)ex);
        }
    }

    private void discoverTags(RdsClient client, DBInstance resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceName(resource.dbInstanceArn()).build()), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.tagList().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }

    private void discoverInstanceDbClusters(RdsClient client, DBInstance resource, MagpieAwsResource data) {
        String keyname = "dbClusters";
        AWSUtils.getAwsResponse(() -> client.describeDBClusters((DescribeDbClustersRequest)DescribeDbClustersRequest.builder().dbClusterIdentifier(resource.dbClusterIdentifier()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("dbClusters", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("dbClusters", noresp)));
    }

    private void discoverInstanceDbSnapshots(RdsClient client, DBInstance resource, MagpieAwsResource data) {
        String keyname = "dbSnapshot";
        AWSUtils.getAwsResponse(() -> client.describeDBSnapshots((DescribeDbSnapshotsRequest)DescribeDbSnapshotsRequest.builder().dbInstanceIdentifier(resource.dbInstanceIdentifier()).includePublic(Boolean.valueOf(false)).includeShared(Boolean.valueOf(true)).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("dbSnapshot", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("dbSnapshot", noresp)));
    }

    private void discoverInstanceSize(DBInstance resource, MagpieAwsResource data, Logger logger, MagpieAWSClientCreator clientCreator) {
        String engine = resource.engine();
        if (engine != null) {
            if ("docdb".equalsIgnoreCase(engine)) {
                this.setDocDBSize(resource, data, logger, clientCreator);
            } else if (engine.startsWith("aurora")) {
                this.setAuroraDBSize(resource, data, logger, clientCreator);
            } else {
                this.setRDSSize(resource, data, logger, clientCreator);
            }
        } else {
            logger.warn("{} RDS instance is missing engine property", (Object)resource.dbInstanceIdentifier());
        }
    }

    private void setRDSSize(DBInstance resource, MagpieAwsResource data, Logger logger, MagpieAWSClientCreator clientCreator) {
        try {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
            dimensions.add((Dimension)Dimension.builder().name("DBInstanceIdentifier").value(resource.dbInstanceIdentifier()).build());
            Pair<Long, GetMetricStatisticsResponse> freeStorageSpace = AWSUtils.getCloudwatchMetricMinimum(data.awsRegion, "AWS/RDS", "FreeStorageSpace", dimensions, clientCreator);
            if (freeStorageSpace.getValue0() != null) {
                logger.warn("{} RDS instance is missing engine property", (Object)resource.dbInstanceIdentifier());
                AWSUtils.update(data.supplementaryConfiguration, Map.of("size", Map.of("FreeStorageSpace", (Long)freeStorageSpace.getValue0())));
                long freeStorageCapacity = (Long)freeStorageSpace.getValue0();
                long storageCapacity = resource.allocatedStorage().intValue();
                data.sizeInBytes = Conversions.GibToBytes(storageCapacity) - freeStorageCapacity;
                data.maxSizeInBytes = Conversions.GibToBytes(storageCapacity);
            } else {
                logger.warn("{} RDS instance is missing size metrics", (Object)resource.dbInstanceIdentifier());
            }
        }
        catch (Exception se) {
            logger.warn("{} RDS instance is missing size metrics, with error {}", (Object)resource.dbInstanceIdentifier(), (Object)se.getMessage());
        }
    }

    private void setDocDBSize(DBInstance resource, MagpieAwsResource data, Logger logger, MagpieAWSClientCreator clientCreator) {
        try {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
            dimensions.add((Dimension)Dimension.builder().name("DBClusterIdentifier").value(resource.dbInstanceIdentifier()).build());
            Pair<Long, GetMetricStatisticsResponse> volumeBytesUsed = AWSUtils.getCloudwatchMetricMaximum(data.awsRegion, "AWS/DocDB", "VolumeBytesUsed", dimensions, clientCreator);
            if (volumeBytesUsed.getValue0() != null) {
                AWSUtils.update(data.supplementaryConfiguration, Map.of("size", Map.of("VolumeBytesUsed", (Long)volumeBytesUsed.getValue0())));
                data.sizeInBytes = (Long)volumeBytesUsed.getValue0();
                data.maxSizeInBytes = Conversions.GibToBytes(resource.allocatedStorage().intValue());
            }
        }
        catch (Exception se) {
            logger.warn("{} RDS instance is missing size metrics, with error {}", (Object)resource.dbInstanceArn(), (Object)se.getMessage());
        }
    }

    private void setAuroraDBSize(DBInstance resource, MagpieAwsResource data, Logger logger, MagpieAWSClientCreator clientCreator) {
        try {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
            dimensions.add((Dimension)Dimension.builder().name("DBClusterIdentifier").value(resource.dbInstanceIdentifier()).build());
            Pair<Long, GetMetricStatisticsResponse> volumeBytesUsed = AWSUtils.getCloudwatchMetricMaximum(data.awsRegion, "AWS/RDS", "VolumeBytesUsed", dimensions, clientCreator);
            if (volumeBytesUsed.getValue0() != null) {
                AWSUtils.update(data.supplementaryConfiguration, Map.of("size", Map.of("VolumeBytesUsed", (Long)volumeBytesUsed.getValue0())));
                data.sizeInBytes = (Long)volumeBytesUsed.getValue0();
                data.maxSizeInBytes = Conversions.GibToBytes(resource.allocatedStorage().intValue());
            }
        }
        catch (Exception se) {
            logger.warn("{} RDS instance is missing size metrics, with error {}", (Object)resource.dbInstanceArn(), (Object)se.getMessage());
        }
    }
}

