/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import io.openraven.magpie.plugins.aws.discovery.services.IAMCredential;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse;
import software.amazon.awssdk.services.iam.model.GetCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.GetUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.Policy;
import software.amazon.awssdk.services.iam.model.PolicyVersion;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.model.Tag;
import software.amazon.awssdk.services.iam.model.User;

public class IAMDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "iam";
    private static final String AWS_LINE_SEPARATOR = "\n";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return IamClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (IamClient client = (IamClient)((IamClientBuilder)clientCreator.apply(IamClient.builder())).build();){
            this.discoverCredentialsReport(client, mapper, session, region, emitter, logger, account);
            this.discoverAccounts(client, mapper, session, region, emitter, account);
            this.discoverGroups(client, mapper, session, region, emitter, account);
            this.discoverUsers(client, mapper, session, region, emitter, account);
            this.discoverRoles(client, mapper, session, region, emitter, account);
            this.discoverPolicies(client, mapper, session, region, emitter, account);
        }
    }

    protected void discoverRoles(IamClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::IAM::Role";
        try {
            client.listRolesPaginator().roles().forEach(listedRole -> {
                Role role = client.getRole(builder -> builder.roleName(listedRole.roleName()).build()).role();
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, role.arn()).withResourceName(role.roleName()).withResourceId(role.roleId()).withResourceType("AWS::IAM::Role").withConfiguration(mapper.valueToTree((Object)role.toBuilder())).withCreatedIso(role.createDate()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverAttachedPolicies(client, data, role);
                this.discoverInlinePolicies(mapper, client, data, role);
                AWSUtils.update(data.tags, Map.of("tags", mapper.convertValue(role.tags().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class)));
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":role"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::IAM::Role", null, region, (SdkException)ex);
        }
    }

    private void discoverInlinePolicies(ObjectMapper mapper, IamClient client, MagpieAwsResource data, Role role) {
        ArrayList inlinePolicies = new ArrayList();
        AWSUtils.getAwsResponse(() -> client.listRolePoliciesPaginator((ListRolePoliciesRequest)ListRolePoliciesRequest.builder().roleName(role.roleName()).build()).policyNames().stream().map(r -> client.getRolePolicy((GetRolePolicyRequest)GetRolePolicyRequest.builder().roleName(role.roleName()).policyName(r).build())).collect(Collectors.toList()), resp -> resp.forEach(policy -> inlinePolicies.add(ImmutableMap.of((Object)"name", (Object)mapper.valueToTree((Object)policy.policyName()), (Object)"policyDocument", (Object)this.parsePolicyDocument(mapper, policy.policyDocument())))), noresp -> {});
        AWSUtils.update(data.supplementaryConfiguration, Map.of("inlinePolicies", inlinePolicies));
    }

    private JsonNode parsePolicyDocument(ObjectMapper mapper, String policyDocument) {
        try {
            return mapper.readTree(URLDecoder.decode(policyDocument, StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to parse inline policy document: " + policyDocument, e);
        }
    }

    private void discoverAttachedPolicies(IamClient client, MagpieAwsResource data, Role role) {
        ArrayList attachedPolicies = new ArrayList();
        AWSUtils.getAwsResponse(() -> client.listAttachedRolePoliciesPaginator((ListAttachedRolePoliciesRequest)ListAttachedRolePoliciesRequest.builder().roleName(role.roleName()).build()).attachedPolicies(), resp -> resp.forEach(attachedRolePolicy -> attachedPolicies.add(ImmutableMap.of((Object)"name", (Object)attachedRolePolicy.policyName(), (Object)"arn", (Object)attachedRolePolicy.policyArn()))), noresp -> {});
        AWSUtils.update(data.supplementaryConfiguration, Map.of("attachedPolicies", attachedPolicies));
    }

    protected void discoverPolicies(IamClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::IAM::Policy";
        try {
            client.listPoliciesPaginator().policies().forEach(policy -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, policy.arn()).withResourceName(policy.policyName()).withResourceId(policy.policyId()).withResourceType("AWS::IAM::Policy").withConfiguration(mapper.valueToTree((Object)policy.toBuilder())).withCreatedIso(policy.createDate()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverPolicyDocument(mapper, client, data, (Policy)policy);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":policy"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::IAM::Policy", null, region, (SdkException)ex);
        }
    }

    private void discoverPolicyDocument(ObjectMapper mapper, IamClient client, MagpieAwsResource data, Policy policy) {
        AWSUtils.getAwsResponse(() -> client.listPolicyVersionsPaginator((ListPolicyVersionsRequest)ListPolicyVersionsRequest.builder().policyArn(policy.arn()).build()), resp -> resp.forEach(policyVersionsResponse -> {
            Optional<PolicyVersion> currentPolicy = policyVersionsResponse.versions().stream().filter(PolicyVersion::isDefaultVersion).findFirst();
            currentPolicy.ifPresent(policyVersion -> AWSUtils.getAwsResponse(() -> client.getPolicyVersion(builder -> builder.policyArn(policy.arn()).versionId(policyVersion.versionId()).build()), innerResp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("attachedPolicies", Map.of("policyDocument", this.parsePolicyDocument(mapper, innerResp.policyVersion().document())))), innerNoresp -> {}));
        }), noresp -> {});
    }

    private void discoverUsers(IamClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::IAM::User";
        try {
            client.listUsersPaginator().users().forEach(user -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, user.arn()).withResourceName(user.userName()).withResourceId(user.userId()).withResourceType("AWS::IAM::User").withConfiguration(mapper.valueToTree((Object)user.toBuilder())).withCreatedIso(user.createDate()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverGroupsForUser(client, data, (User)user);
                this.discoverAttachedUserPolicies(client, data, (User)user);
                this.discoverUserPolicies(client, data, (User)user);
                this.discoverUserMFADevices(client, data, (User)user);
                AWSUtils.update(data.tags, (JsonNode)mapper.convertValue(user.tags().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class));
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":user"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::IAM::User", null, region, (SdkException)ex);
        }
    }

    private void discoverGroupsForUser(IamClient client, MagpieAwsResource data, User user) {
        ArrayList attachedPolicies = new ArrayList();
        AWSUtils.getAwsResponse(() -> client.listGroupsForUserPaginator((ListGroupsForUserRequest)ListGroupsForUserRequest.builder().userName(user.userName()).build()).groups(), resp -> resp.forEach(group -> attachedPolicies.add(ImmutableMap.of((Object)"name", (Object)group.groupName(), (Object)"arn", (Object)group.arn()))), noresp -> {});
        AWSUtils.update(data.supplementaryConfiguration, Map.of("groups", attachedPolicies));
    }

    private void discoverAttachedUserPolicies(IamClient client, MagpieAwsResource data, User user) {
        ArrayList attachedPolicies = new ArrayList();
        AWSUtils.getAwsResponse(() -> client.listAttachedUserPoliciesPaginator((ListAttachedUserPoliciesRequest)ListAttachedUserPoliciesRequest.builder().userName(user.userName()).build()).attachedPolicies(), resp -> resp.forEach(attachUserPolicy -> attachedPolicies.add(ImmutableMap.of((Object)"name", (Object)attachUserPolicy.policyName(), (Object)"arn", (Object)attachUserPolicy.policyArn()))), noresp -> {});
        AWSUtils.update(data.supplementaryConfiguration, Map.of("attachedPolicies", attachedPolicies));
    }

    private void discoverUserPolicies(IamClient client, MagpieAwsResource data, User user) {
        ArrayList inlinePolicies = new ArrayList();
        AWSUtils.getAwsResponse(() -> client.listUserPoliciesPaginator((ListUserPoliciesRequest)ListUserPoliciesRequest.builder().userName(user.userName()).build()).policyNames(), resp -> resp.forEach(policyName -> AWSUtils.getAwsResponse(() -> client.getUserPolicy((GetUserPolicyRequest)GetUserPolicyRequest.builder().userName(user.userName()).policyName(policyName).build()), innerResp -> inlinePolicies.add(ImmutableMap.of((Object)"name", (Object)innerResp.policyName(), (Object)"policyDocument", (Object)innerResp.policyDocument())), innerNoresp -> {})), noresp -> {});
        AWSUtils.update(data.supplementaryConfiguration, Map.of("userPolicies", inlinePolicies));
    }

    private void discoverUserMFADevices(IamClient client, MagpieAwsResource data, User user) {
        String keyname = "mfaDevices";
        AWSUtils.getAwsResponse(() -> client.listMFADevicesPaginator((ListMfaDevicesRequest)ListMfaDevicesRequest.builder().userName(user.userName()).build()).stream().map(ListMfaDevicesResponse::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of(keyname, resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of(keyname, noresp)));
    }

    protected void discoverGroups(IamClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::IAM::Group";
        try {
            client.listGroups().groups().forEach(group -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, group.arn()).withResourceName(group.groupName()).withResourceId(group.groupId()).withResourceType("AWS::IAM::Group").withConfiguration(mapper.valueToTree((Object)group.toBuilder())).withCreatedIso(group.createDate()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverGroupInlinePolicies(client, data, (Group)group);
                this.discoverGroupAttachedPolicies(client, data, (Group)group);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":group"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::IAM::Group", null, region, (SdkException)ex);
        }
    }

    private void discoverGroupInlinePolicies(IamClient client, MagpieAwsResource data, Group group) {
        ArrayList inlinePolicies = new ArrayList();
        AWSUtils.getAwsResponse(() -> client.listGroupPoliciesPaginator((ListGroupPoliciesRequest)ListGroupPoliciesRequest.builder().groupName(group.groupName()).build()).policyNames().stream().map(r -> client.getGroupPolicy((GetGroupPolicyRequest)GetGroupPolicyRequest.builder().groupName(group.groupName()).policyName(r).build())), resp -> resp.forEach(rolePolicy -> inlinePolicies.add(ImmutableMap.of((Object)"name", (Object)rolePolicy.policyName(), (Object)"policyDocument", (Object)rolePolicy.policyDocument()))), noresp -> {});
        AWSUtils.update(data.supplementaryConfiguration, Map.of("inlinePolicies", inlinePolicies));
    }

    private void discoverGroupAttachedPolicies(IamClient client, MagpieAwsResource data, Group group) {
        ArrayList attachedPolicies = new ArrayList();
        AWSUtils.getAwsResponse(() -> client.listAttachedGroupPoliciesPaginator((ListAttachedGroupPoliciesRequest)ListAttachedGroupPoliciesRequest.builder().groupName(group.groupName()).build()).attachedPolicies(), resp -> resp.forEach(attachedGroupPolicy -> attachedPolicies.add(ImmutableMap.of((Object)"name", (Object)attachedGroupPolicy.policyName(), (Object)"arn", (Object)attachedGroupPolicy.policyArn()))), noresp -> {});
        AWSUtils.update(data.supplementaryConfiguration, Map.of("attachedPolicies", attachedPolicies));
    }

    protected void discoverAccounts(IamClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::IAM::Account";
        try {
            GetAccountSummaryResponse accountSummary = client.getAccountSummary();
            MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, "AWS::IAM::Account").withResourceType("AWS::IAM::Account").withAccountId(account).withAwsRegion(region.toString()).withConfiguration(mapper.valueToTree((Object)accountSummary.summaryMapAsStrings())).build();
            this.discoverAccountAlias(client, data);
            this.discoverAccountPasswordPolicy(client, data);
            this.discoverVirtualMFADevices(client, data);
            emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":account"), data.toJsonNode()));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("Account", null, region, (SdkException)ex);
        }
    }

    private void discoverAccountAlias(IamClient client, MagpieAwsResource data) {
        AWSUtils.getAwsResponse(() -> client.listAccountAliases().accountAliases().stream().findFirst().orElse(null), resp -> {
            data.resourceName = resp;
        }, noresp -> {});
    }

    private void discoverAccountPasswordPolicy(IamClient client, MagpieAwsResource data) {
        String keyname = "PasswordPolicy";
        AWSUtils.getAwsResponse(() -> client.getAccountPasswordPolicy().passwordPolicy(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("PasswordPolicy", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("PasswordPolicy", noresp)));
    }

    private void discoverVirtualMFADevices(IamClient client, MagpieAwsResource data) {
        String keyname = "virtualMFADevices";
        AWSUtils.getAwsResponse(() -> client.listVirtualMFADevices().toBuilder(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("virtualMFADevices", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("virtualMFADevices", noresp)));
    }

    protected void discoverCredentialsReport(IamClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account) {
        AWSUtils.getAwsResponse(() -> this.generateCredentialReport(client), resp -> {
            if (resp.booleanValue()) {
                this.processCredentialsReport(client, mapper, session, region, emitter, account);
            } else {
                logger.error("Failed to generate credentialsReport in {}", (Object)region.id());
            }
        }, noresp -> logger.error("Failed to get credentialsReport in {}", (Object)region.id()));
    }

    private boolean generateCredentialReport(IamClient client) {
        String status = client.generateCredentialReport().stateAsString();
        for (int numTries = 0; !status.equals("COMPLETE") && numTries < 5; ++numTries) {
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            status = client.generateCredentialReport().stateAsString();
        }
        return status.equals("COMPLETE");
    }

    private void processCredentialsReport(IamClient client, ObjectMapper mapper, Session session, Region region, Emitter emitter, String account) {
        String RESOURCE_TYPE = "AWS::IAM::CredentialsReport";
        GetCredentialReportResponse report = client.getCredentialReport();
        String reportContent = report.content().asUtf8String();
        String[] reportLines = reportContent.split(AWS_LINE_SEPARATOR);
        for (int i = 1; i < reportLines.length; ++i) {
            IAMCredential credential = new IAMCredential(reportLines[i]);
            MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, credential.arn).withResourceName(credential.user).withResourceId(credential.arn).withResourceType("AWS::IAM::CredentialsReport").withConfiguration(mapper.valueToTree((Object)credential)).withAccountId(account).withAwsRegion(region.toString()).build();
            emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":credentialsReport"), data.toJsonNode()));
        }
    }
}

