/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.CloudFrontClientBuilder;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.Tag;

public class CloudFrontDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "cloudFront";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return CloudFrontClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::CloudFront::Distribution";
        try (CloudFrontClient client = (CloudFrontClient)((CloudFrontClientBuilder)clientCreator.apply(CloudFrontClient.builder())).build();){
            client.listDistributions().distributionList().items().forEach(distribution -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, distribution.arn()).withResourceName(distribution.domainName()).withResourceId(distribution.id()).withResourceType("AWS::CloudFront::Distribution").withConfiguration(mapper.valueToTree((Object)distribution.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverTags(client, (DistributionSummary)distribution, data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":distribution"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::CloudFront::Distribution", null, region, (SdkException)ex);
        }
    }

    private void discoverTags(CloudFrontClient client, DistributionSummary resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resource(resource.arn()).build()), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.tags().items().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }
}

