/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClient;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClientBuilder;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;

public class EBDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "eb";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return ElasticBeanstalkClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::ElasticBeanstalk";
        try (ElasticBeanstalkClient client = (ElasticBeanstalkClient)((ElasticBeanstalkClientBuilder)clientCreator.apply(ElasticBeanstalkClient.builder())).build();){
            client.describeEnvironments().environments().forEach(environment -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, environment.environmentArn()).withResourceName(environment.environmentName()).withResourceType("AWS::ElasticBeanstalk").withConfiguration(mapper.valueToTree((Object)environment.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverApplication(client, (EnvironmentDescription)environment, data);
                this.discoverConfigurationSettings(client, (EnvironmentDescription)environment, data);
                this.discoverEnvironmentResources(client, (EnvironmentDescription)environment, data);
                this.discoverEnvironmentManagedActions(client, (EnvironmentDescription)environment, data);
                this.discoverTags(client, (EnvironmentDescription)environment, data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":environment"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::ElasticBeanstalk", null, region, (SdkException)ex);
        }
    }

    private void discoverApplication(ElasticBeanstalkClient client, EnvironmentDescription resource, MagpieAwsResource data) {
        String keyname = "application";
        AWSUtils.getAwsResponse(() -> client.describeApplications((DescribeApplicationsRequest)DescribeApplicationsRequest.builder().applicationNames(new String[]{resource.applicationName()}).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("application", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("application", noresp)));
    }

    private void discoverConfigurationSettings(ElasticBeanstalkClient client, EnvironmentDescription resource, MagpieAwsResource data) {
        String keyname = "configurationSettings";
        AWSUtils.getAwsResponse(() -> client.describeConfigurationSettings((DescribeConfigurationSettingsRequest)DescribeConfigurationSettingsRequest.builder().applicationName(resource.applicationName()).environmentName(resource.environmentName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("configurationSettings", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("configurationSettings", noresp)));
    }

    private void discoverEnvironmentResources(ElasticBeanstalkClient client, EnvironmentDescription resource, MagpieAwsResource data) {
        String keyname = "environmentResources";
        AWSUtils.getAwsResponse(() -> client.describeEnvironmentResources((DescribeEnvironmentResourcesRequest)DescribeEnvironmentResourcesRequest.builder().environmentName(resource.environmentName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("environmentResources", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("environmentResources", noresp)));
    }

    private void discoverEnvironmentManagedActions(ElasticBeanstalkClient client, EnvironmentDescription resource, MagpieAwsResource data) {
        String keyname = "environmentManagedActions";
        AWSUtils.getAwsResponse(() -> client.describeEnvironmentManagedActions((DescribeEnvironmentManagedActionsRequest)DescribeEnvironmentManagedActionsRequest.builder().environmentName(resource.environmentName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("environmentManagedActions", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("environmentManagedActions", noresp)));
    }

    private void discoverTags(ElasticBeanstalkClient client, EnvironmentDescription resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceArn(resource.environmentArn()).build()), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.resourceTags().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }
}

