/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import org.slf4j.Logger;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;

public class RegionDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "region";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String arn = String.format("arn:aws::%s:%s", region.id(), account);
        RegionMetadata metadata = region.metadata();
        String resourceName = metadata != null ? metadata.description() : "";
        MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(resourceName).withResourceId(region.id()).withResourceType("AWS::Region").withConfiguration((JsonNode)NullNode.instance).withAccountId(account).withAwsRegion(region.id()).build();
        emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService()), data.toJsonNode()));
    }

    @Override
    public List<Region> getSupportedRegions() {
        return Region.regions();
    }
}

