/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.kms.model.AliasListEntry;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListResourceTagsRequest;
import software.amazon.awssdk.services.kms.model.Tag;

public class KMSDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "kms";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return KmsClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Kms::Key";
        try (KmsClient client = (KmsClient)((KmsClientBuilder)clientCreator.apply(KmsClient.builder())).build();){
            client.listKeysPaginator().keys().forEach(key -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, key.keyArn()).withResourceName(key.toString()).withResourceId(key.keyId()).withResourceType("AWS::Kms::Key").withConfiguration(mapper.valueToTree((Object)key.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverKeyRotation(client, (KeyListEntry)key, data);
                this.discoverAliases(client, (KeyListEntry)key, data);
                this.discoverKeyPolicies(client, (KeyListEntry)key, data);
                this.discoverGrants(client, (KeyListEntry)key, data);
                this.discoverTags(client, (KeyListEntry)key, data, mapper);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService()), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Kms::Key", null, region, (SdkException)ex);
        }
    }

    private void discoverKeyRotation(KmsClient client, KeyListEntry resource, MagpieAwsResource data) {
        String keyname = "rotation";
        AWSUtils.getAwsResponse(() -> client.getKeyRotationStatus((GetKeyRotationStatusRequest)GetKeyRotationStatusRequest.builder().keyId(resource.keyId()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("rotation", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("rotation", noresp)));
    }

    private void discoverAliases(KmsClient client, KeyListEntry resource, MagpieAwsResource data) {
        String keyname = "aliases";
        AWSUtils.getAwsResponse(() -> client.listAliasesPaginator((ListAliasesRequest)ListAliasesRequest.builder().keyId(resource.keyId()).build()).aliases().stream().map(AliasListEntry::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("aliases", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("aliases", noresp)));
    }

    private void discoverKeyPolicies(KmsClient client, KeyListEntry resource, MagpieAwsResource data) {
        String keyname = "keyPolicies";
        AWSUtils.getAwsResponse(() -> client.listKeyPolicies((ListKeyPoliciesRequest)ListKeyPoliciesRequest.builder().keyId(resource.keyId()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("keyPolicies", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("keyPolicies", noresp)));
    }

    private void discoverGrants(KmsClient client, KeyListEntry resource, MagpieAwsResource data) {
        String keyname = "grants";
        AWSUtils.getAwsResponse(() -> client.listGrants((ListGrantsRequest)ListGrantsRequest.builder().keyId(resource.keyId()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("grants", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("grants", noresp)));
    }

    private void discoverTags(KmsClient client, KeyListEntry resource, MagpieAwsResource data, ObjectMapper mapper) {
        AWSUtils.getAwsResponse(() -> client.listResourceTags((ListResourceTagsRequest)ListResourceTagsRequest.builder().keyId(resource.keyId()).build()), resp -> {
            JsonNode tagsNode = (JsonNode)mapper.convertValue(resp.tags().stream().collect(Collectors.toMap(Tag::tagKey, Tag::tagValue)), JsonNode.class);
            AWSUtils.update(data.tags, tagsNode);
        }, noresp -> AWSUtils.update(data.tags, noresp));
    }
}

