/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;

public class CloudWatchLogsDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "cloudWatchLogs";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return CloudWatchLogsClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (CloudWatchLogsClient client = (CloudWatchLogsClient)((CloudWatchLogsClientBuilder)clientCreator.apply(CloudWatchLogsClient.builder())).build();){
            this.discoverLogGroups(mapper, session, region, emitter, client, account);
            this.discoverLogs(mapper, session, region, emitter, client, account);
        }
    }

    private void discoverLogs(ObjectMapper mapper, Session session, Region region, Emitter emitter, CloudWatchLogsClient client, String account) {
        String RESOURCE_TYPE = "AWS::CloudWatchLogs::MetricFilter";
        try {
            client.describeMetricFiltersPaginator().metricFilters().forEach(metricFilter -> {
                String arn = String.format("arn:aws:cloudwatchlogs:%s:%s:metric-filter/%s", region, account, metricFilter.filterName());
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, arn).withResourceName(metricFilter.filterName()).withResourceType("AWS::CloudWatchLogs::MetricFilter").withCreatedIso(Instant.ofEpochMilli(metricFilter.creationTime())).withConfiguration(mapper.valueToTree((Object)metricFilter.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":metricFilter"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::CloudWatchLogs::MetricFilter", null, region, (SdkException)ex);
        }
    }

    private void discoverLogGroups(ObjectMapper mapper, Session session, Region region, Emitter emitter, CloudWatchLogsClient client, String account) {
        String RESOURCE_TYPE = "AWS::CloudWatchLogs::LogGroup";
        try {
            String nextToken = null;
            do {
                DescribeLogGroupsResponse resp = client.describeLogGroups((DescribeLogGroupsRequest)DescribeLogGroupsRequest.builder().nextToken(nextToken).build());
                nextToken = resp.nextToken();
                resp.logGroups().forEach(logGroup -> {
                    MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, logGroup.arn()).withResourceName(logGroup.logGroupName()).withResourceType("AWS::CloudWatchLogs::LogGroup").withCreatedIso(Instant.ofEpochMilli(logGroup.creationTime())).withConfiguration(mapper.valueToTree((Object)logGroup.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                    emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":logGroup"), data.toJsonNode()));
                });
            } while (!Strings.isNullOrEmpty((String)nextToken));
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::CloudWatchLogs::LogGroup", null, region, (SdkException)ex);
        }
    }
}

