/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import io.openraven.magpie.plugins.aws.discovery.AWSDiscoveryConfig;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import java.net.URI;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class ClientCreators {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCreators.class);
    public static final StsClient localStsClient = StsClient.create();

    public static MagpieAWSClientCreator assumeRoleCreator(final Region region, final String roleArn, final @Nullable String externalId, final @Nullable AWSDiscoveryConfig.ProxyRoleConfig proxyRoleConfig) {
        return new MagpieAWSClientCreator(){

            @Override
            public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> BuilderT apply(AwsClientBuilder<BuilderT, ClientT> builder) {
                String magpieAwsEndpoint = System.getProperty("MAGPIE_AWS_ENDPOINT");
                if (magpieAwsEndpoint != null) {
                    builder.endpointOverride(URI.create(magpieAwsEndpoint));
                }
                StsClient stsClient = localStsClient;
                if (proxyRoleConfig != null) {
                    String arn = proxyRoleConfig.getArn();
                    String proxyRoleConfigExternalId = proxyRoleConfig.getExternalId();
                    LOGGER.debug("Using proxyRoleConfig with arn={}, externalId={} connecting to roleArn={}, externalId={}", new Object[]{arn, proxyRoleConfigExternalId, roleArn, externalId});
                    AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleArn(arn).externalId(proxyRoleConfigExternalId).roleSessionName(UUID.randomUUID().toString());
                    StsAssumeRoleCredentialsProvider provider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(localStsClient)).refreshRequest((AssumeRoleRequest)assumeRoleRequestBuilder.build()).build();
                    stsClient = (StsClient)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)provider)).build();
                }
                AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(UUID.randomUUID().toString()).externalId(externalId);
                StsAssumeRoleCredentialsProvider provider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)assumeRoleRequestBuilder.build()).build();
                return (BuilderT)builder.credentialsProvider((AwsCredentialsProvider)provider).region(region);
            }
        };
    }

    public static MagpieAWSClientCreator localClientCreator(final Region region) {
        return new MagpieAWSClientCreator(){

            @Override
            public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> BuilderT apply(AwsClientBuilder<BuilderT, ClientT> builder) {
                String magpieAwsEndpoint = System.getProperty("MAGPIE_AWS_ENDPOINT");
                if (magpieAwsEndpoint != null) {
                    builder.endpointOverride(URI.create(magpieAwsEndpoint));
                }
                return (BuilderT)builder.region(region);
            }
        };
    }
}

