/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.Conversions;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lightsail.LightsailClient;
import software.amazon.awssdk.services.lightsail.LightsailClientBuilder;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;
import software.amazon.awssdk.services.lightsail.model.MetricStatistic;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabase;

public class LightsailDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "lightsail";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return LightsailClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        try (LightsailClient client = (LightsailClient)((LightsailClientBuilder)clientCreator.apply(LightsailClient.builder())).build();){
            this.discoverDatabases(mapper, session, region, emitter, client, account);
            this.discoverInstances(mapper, session, region, emitter, client, account);
            this.discoverLoadBalancers(mapper, session, region, emitter, client, account);
        }
    }

    private void discoverDatabases(ObjectMapper mapper, Session session, Region region, Emitter emitter, LightsailClient client, String account) {
        String RESOURCE_TYPE = "AWS::Lightsail::Database";
        try {
            client.getRelationalDatabases((GetRelationalDatabasesRequest)GetRelationalDatabasesRequest.builder().build()).relationalDatabases().forEach(relationalDatabase -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, relationalDatabase.arn()).withResourceName(relationalDatabase.name()).withResourceType("AWS::Lightsail::Database").withConfiguration(mapper.valueToTree((Object)relationalDatabase.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverSize(client, (RelationalDatabase)relationalDatabase, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":relationalDatabase"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Lightsail::Database", null, region, (SdkException)ex);
        }
    }

    private void discoverSize(LightsailClient client, RelationalDatabase resource, MagpieAwsResource data) {
        GetRelationalDatabaseMetricDataRequest request = (GetRelationalDatabaseMetricDataRequest)GetRelationalDatabaseMetricDataRequest.builder().relationalDatabaseName(resource.name()).metricName("FreeStorageSpace").period(Integer.valueOf(60)).startTime(Instant.now().minus(1L, ChronoUnit.MINUTES)).endTime(Instant.now()).unit("Bytes").statistics(new MetricStatistic[]{MetricStatistic.MINIMUM}).build();
        GetRelationalDatabaseMetricDataResponse response = client.getRelationalDatabaseMetricData(request);
        long diskSizeInBytes = Conversions.GibToBytes(resource.hardware().diskSizeInGb().intValue());
        if (!response.metricData().isEmpty()) {
            AWSUtils.update(data.supplementaryConfiguration, Map.of("FreeStorageSpace", ((MetricDatapoint)response.metricData().get(0)).minimum().longValue()));
            AWSUtils.update(data.supplementaryConfiguration, Map.of("SizeInBytes", diskSizeInBytes - ((MetricDatapoint)response.metricData().get(0)).minimum().longValue()));
            AWSUtils.update(data.supplementaryConfiguration, Map.of("DiskSizeInBytes", diskSizeInBytes));
            data.sizeInBytes = diskSizeInBytes - ((MetricDatapoint)response.metricData().get(0)).minimum().longValue();
        }
        data.maxSizeInBytes = diskSizeInBytes;
    }

    private void discoverInstances(ObjectMapper mapper, Session session, Region region, Emitter emitter, LightsailClient client, String account) {
        String RESOURCE_TYPE = "AWS::Lightsail::Instance";
        try {
            client.getInstances((GetInstancesRequest)GetInstancesRequest.builder().build()).instances().forEach(instance -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, instance.arn()).withResourceName(instance.name()).withResourceType("AWS::Lightsail::Instance").withConfiguration(mapper.valueToTree((Object)instance.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":instance"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Lightsail::Instance", null, region, (SdkException)ex);
        }
    }

    private void discoverLoadBalancers(ObjectMapper mapper, Session session, Region region, Emitter emitter, LightsailClient client, String account) {
        String RESOURCE_TYPE = "AWS::Lightsail::LoadBalancer";
        try {
            client.getLoadBalancers().loadBalancers().forEach(loadBalancer -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, loadBalancer.arn()).withResourceName(loadBalancer.name()).withResourceType("AWS::Lightsail::LoadBalancer").withConfiguration(mapper.valueToTree((Object)loadBalancer.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":loadBalancer"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Lightsail::LoadBalancer", null, region, (SdkException)ex);
        }
    }
}

