/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.GlacierClientBuilder;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.GlacierJobDescription;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.model.UploadListElement;

public class GlacierDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "glacier";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return GlacierClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::Glacier::Vault";
        try (GlacierClient client = (GlacierClient)((GlacierClientBuilder)clientCreator.apply(GlacierClient.builder())).build();){
            client.listVaultsPaginator().vaultList().stream().forEach(vault -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, vault.vaultARN()).withResourceName(vault.vaultName()).withResourceType("AWS::Glacier::Vault").withConfiguration(mapper.valueToTree((Object)vault.toBuilder())).withCreatedIso(Instant.parse(vault.creationDate())).withSizeInBytes(vault.sizeInBytes()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverJobs(client, (DescribeVaultOutput)vault, data);
                this.discoverMultipartUploads(client, (DescribeVaultOutput)vault, data);
                this.discoverAccessPolicy(client, (DescribeVaultOutput)vault, data);
                this.discoverVaultLock(client, (DescribeVaultOutput)vault, data);
                this.discoverVaultNotifications(client, (DescribeVaultOutput)vault, data);
                this.discoverTags(client, (DescribeVaultOutput)vault, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":vault"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::Glacier::Vault", null, region, (SdkException)ex);
        }
    }

    private void discoverJobs(GlacierClient client, DescribeVaultOutput resource, MagpieAwsResource data) {
        String keyname = "jobs";
        AWSUtils.getAwsResponse(() -> client.listJobsPaginator((ListJobsRequest)ListJobsRequest.builder().vaultName(resource.vaultName()).build()).jobList().stream().map(GlacierJobDescription::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("jobs", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("jobs", noresp)));
    }

    private void discoverMultipartUploads(GlacierClient client, DescribeVaultOutput resource, MagpieAwsResource data) {
        String keyname = "multipartUploads";
        AWSUtils.getAwsResponse(() -> client.listMultipartUploadsPaginator((ListMultipartUploadsRequest)ListMultipartUploadsRequest.builder().vaultName(resource.vaultName()).build()).uploadsList().stream().map(UploadListElement::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("multipartUploads", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("multipartUploads", noresp)));
    }

    private void discoverAccessPolicy(GlacierClient client, DescribeVaultOutput resource, MagpieAwsResource data) {
        String keyname = "accessPolicy";
        AWSUtils.getAwsResponse(() -> client.getVaultAccessPolicy((GetVaultAccessPolicyRequest)GetVaultAccessPolicyRequest.builder().vaultName(resource.vaultName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("accessPolicy", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("accessPolicy", noresp)));
    }

    private void discoverVaultNotifications(GlacierClient client, DescribeVaultOutput resource, MagpieAwsResource data) {
        String keyname = "vaultNotifications";
        AWSUtils.getAwsResponse(() -> client.getVaultNotifications((GetVaultNotificationsRequest)GetVaultNotificationsRequest.builder().vaultName(resource.vaultName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("vaultNotifications", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("vaultNotifications", noresp)));
    }

    private void discoverVaultLock(GlacierClient client, DescribeVaultOutput resource, MagpieAwsResource data) {
        String keyname = "vaultLock";
        AWSUtils.getAwsResponse(() -> client.getVaultLock((GetVaultLockRequest)GetVaultLockRequest.builder().vaultName(resource.vaultName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("vaultLock", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("vaultLock", noresp)));
    }

    private void discoverTags(GlacierClient client, DescribeVaultOutput resource, MagpieAwsResource data) {
        String keyname = "tags";
        AWSUtils.getAwsResponse(() -> client.listTagsForVault((ListTagsForVaultRequest)ListTagsForVaultRequest.builder().vaultName(resource.vaultName()).build()).tags(), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("tags", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("tags", noresp)));
    }
}

