/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.EksClientBuilder;
import software.amazon.awssdk.services.eks.model.Cluster;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest;
import software.amazon.awssdk.services.eks.model.DescribeUpdateRequest;
import software.amazon.awssdk.services.eks.model.DescribeUpdateResponse;
import software.amazon.awssdk.services.eks.model.FargateProfile;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest;
import software.amazon.awssdk.services.eks.model.ListNodegroupsRequest;
import software.amazon.awssdk.services.eks.model.ListUpdatesRequest;
import software.amazon.awssdk.services.eks.model.Nodegroup;

public class EKSDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "eks";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return EksClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::EKS::Cluster";
        try (EksClient client = (EksClient)((EksClientBuilder)clientCreator.apply(EksClient.builder())).build();){
            client.listClustersPaginator().clusters().stream().map(clusterName -> client.describeCluster((DescribeClusterRequest)DescribeClusterRequest.builder().name(clusterName).build())).forEach(cluster -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, cluster.cluster().arn()).withResourceName(cluster.cluster().name()).withResourceType("AWS::EKS::Cluster").withConfiguration(mapper.valueToTree((Object)cluster.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverFargateProfiles(client, cluster.cluster(), data);
                this.discoverNodegroups(client, cluster.cluster(), data);
                this.discoverUpdates(client, cluster.cluster(), data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":cluster"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EKS::Cluster", null, region, (SdkException)ex);
        }
    }

    private void discoverFargateProfiles(EksClient client, Cluster cluster, MagpieAwsResource data) {
        String keyname = "fargateProfiles";
        AWSUtils.getAwsResponse(() -> client.listFargateProfilesPaginator((ListFargateProfilesRequest)ListFargateProfilesRequest.builder().clusterName(cluster.name()).build()).fargateProfileNames().stream().map(profileName -> client.describeFargateProfile((DescribeFargateProfileRequest)DescribeFargateProfileRequest.builder().clusterName(cluster.name()).fargateProfileName(profileName).build()).fargateProfile()).map(FargateProfile::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("fargateProfiles", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("fargateProfiles", noresp)));
    }

    private void discoverNodegroups(EksClient client, Cluster cluster, MagpieAwsResource data) {
        String keyname = "nodegroups";
        AWSUtils.getAwsResponse(() -> client.listNodegroups((ListNodegroupsRequest)ListNodegroupsRequest.builder().clusterName(cluster.name()).build()).nodegroups().stream().map(nodegroupName -> client.describeNodegroup((DescribeNodegroupRequest)DescribeNodegroupRequest.builder().clusterName(cluster.name()).nodegroupName(nodegroupName).build()).nodegroup()).map(Nodegroup::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("nodegroups", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("nodegroups", noresp)));
    }

    private void discoverUpdates(EksClient client, Cluster cluster, MagpieAwsResource data) {
        String keyname = "updates";
        AWSUtils.getAwsResponse(() -> client.listUpdates((ListUpdatesRequest)ListUpdatesRequest.builder().name(cluster.name()).build()).updateIds().stream().map(updateId -> client.describeUpdate((DescribeUpdateRequest)DescribeUpdateRequest.builder().name(cluster.name()).updateId(updateId).build())).map(DescribeUpdateResponse::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("updates", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("updates", noresp)));
    }
}

