/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.EmrClientBuilder;
import software.amazon.awssdk.services.emr.model.ClusterSummary;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.InstanceGroup;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstancesRequest;
import software.amazon.awssdk.services.emr.model.ListInstancesResponse;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.services.emr.model.StepSummary;

public class EMRDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "emr";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return EmrClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::EMR::Cluster";
        try (EmrClient client = (EmrClient)((EmrClientBuilder)clientCreator.apply(EmrClient.builder())).build();){
            client.listClustersPaginator().clusters().stream().forEach(cluster -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, cluster.clusterArn()).withResourceName(cluster.name()).withResourceId(cluster.id()).withResourceType("AWS::EMR::Cluster").withConfiguration(mapper.valueToTree((Object)cluster.toBuilder())).withCreatedIso(cluster.status().timeline().creationDateTime()).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverSteps(client, (ClusterSummary)cluster, data);
                this.discoverInstances(client, (ClusterSummary)cluster, data);
                this.discoverInstanceFleets(client, (ClusterSummary)cluster, data);
                this.discoverInstanceGroups(client, (ClusterSummary)cluster, data);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":cluster"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::EMR::Cluster", null, region, (SdkException)ex);
        }
    }

    private void discoverSteps(EmrClient client, ClusterSummary resource, MagpieAwsResource data) {
        String keyname = "steps";
        AWSUtils.getAwsResponse(() -> client.listStepsPaginator((ListStepsRequest)ListStepsRequest.builder().clusterId(resource.id()).build()).steps().stream().map(StepSummary::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("steps", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("steps", noresp)));
    }

    private void discoverInstances(EmrClient client, ClusterSummary resource, MagpieAwsResource data) {
        String keyname = "instances";
        AWSUtils.getAwsResponse(() -> client.listInstancesPaginator((ListInstancesRequest)ListInstancesRequest.builder().clusterId(resource.id()).build()).stream().map(ListInstancesResponse::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("instances", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("instances", noresp)));
    }

    private void discoverInstanceFleets(EmrClient client, ClusterSummary resource, MagpieAwsResource data) {
        String keyname = "instancesFleet";
        AWSUtils.getAwsResponse(() -> client.listInstanceFleetsPaginator((ListInstanceFleetsRequest)ListInstanceFleetsRequest.builder().clusterId(resource.id()).build()).instanceFleets().stream().map(InstanceFleet::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("instancesFleet", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("instancesFleet", noresp)));
    }

    private void discoverInstanceGroups(EmrClient client, ClusterSummary resource, MagpieAwsResource data) {
        String keyname = "instancesGroups";
        AWSUtils.getAwsResponse(() -> client.listInstanceGroups((ListInstanceGroupsRequest)ListInstanceGroupsRequest.builder().clusterId(resource.id()).build()).instanceGroups().stream().map(InstanceGroup::toBuilder).collect(Collectors.toList()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("instancesGroups", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("instancesGroups", noresp)));
    }
}

