/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.api.Emitter;
import io.openraven.magpie.api.MagpieAwsResource;
import io.openraven.magpie.api.Session;
import io.openraven.magpie.plugins.aws.discovery.AWSUtils;
import io.openraven.magpie.plugins.aws.discovery.DiscoveryExceptions;
import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import io.openraven.magpie.plugins.aws.discovery.VersionedMagpieEnvelopeProvider;
import io.openraven.magpie.plugins.aws.discovery.services.AWSDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;
import org.slf4j.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudsearch.CloudSearchClient;
import software.amazon.awssdk.services.cloudsearch.CloudSearchClientBuilder;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatus;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;

public class CloudSearchDiscovery
implements AWSDiscovery {
    private static final String SERVICE = "cloudSearch";

    @Override
    public String service() {
        return SERVICE;
    }

    @Override
    public List<Region> getSupportedRegions() {
        return CloudSearchClient.serviceMetadata().regions();
    }

    @Override
    public void discover(ObjectMapper mapper, Session session, Region region, Emitter emitter, Logger logger, String account, MagpieAWSClientCreator clientCreator) {
        String RESOURCE_TYPE = "AWS::CloudSearch::Domain";
        try (CloudSearchClient client = (CloudSearchClient)((CloudSearchClientBuilder)clientCreator.apply(CloudSearchClient.builder())).build();){
            client.describeDomains((DescribeDomainsRequest)DescribeDomainsRequest.builder().domainNames(client.listDomainNames().domainNames().keySet()).build()).domainStatusList().forEach(domain -> {
                MagpieAwsResource data = new MagpieAwsResource.MagpieAwsResourceBuilder(mapper, domain.arn()).withResourceName(domain.domainName()).withResourceId(domain.domainId()).withResourceType("AWS::CloudSearch::Domain").withConfiguration(mapper.valueToTree((Object)domain.toBuilder())).withAccountId(account).withAwsRegion(region.toString()).build();
                this.discoverSuggesters(client, (DomainStatus)domain, data);
                this.discoverServiceAccessPolicies(client, (DomainStatus)domain, data);
                this.discoverExpressions(client, (DomainStatus)domain, data);
                this.discoverIndexFields(client, (DomainStatus)domain, data);
                this.discoverSize((DomainStatus)domain, data, account, clientCreator);
                emitter.emit(VersionedMagpieEnvelopeProvider.create(session, List.of(this.fullService() + ":domain"), data.toJsonNode()));
            });
        }
        catch (SdkClientException | SdkServiceException ex) {
            DiscoveryExceptions.onDiscoveryException("AWS::CloudSearch::Domain", null, region, (SdkException)ex);
        }
    }

    private void discoverSuggesters(CloudSearchClient cloudSearchClient, DomainStatus domainStatus, MagpieAwsResource data) {
        String keyname = "suggesters";
        AWSUtils.getAwsResponse(() -> cloudSearchClient.describeSuggesters((DescribeSuggestersRequest)DescribeSuggestersRequest.builder().domainName(domainStatus.domainName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("suggesters", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("suggesters", noresp)));
    }

    private void discoverServiceAccessPolicies(CloudSearchClient cloudSearchClient, DomainStatus domainStatus, MagpieAwsResource data) {
        String keyname = "serviceAccessPolicies";
        AWSUtils.getAwsResponse(() -> cloudSearchClient.describeServiceAccessPolicies((DescribeServiceAccessPoliciesRequest)DescribeServiceAccessPoliciesRequest.builder().domainName(domainStatus.domainName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("serviceAccessPolicies", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("serviceAccessPolicies", noresp)));
    }

    private void discoverIndexFields(CloudSearchClient cloudSearchClient, DomainStatus domainStatus, MagpieAwsResource data) {
        String keyname = "indexFields";
        AWSUtils.getAwsResponse(() -> cloudSearchClient.describeIndexFields((DescribeIndexFieldsRequest)DescribeIndexFieldsRequest.builder().domainName(domainStatus.domainName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("indexFields", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("indexFields", noresp)));
    }

    private void discoverExpressions(CloudSearchClient cloudSearchClient, DomainStatus domainStatus, MagpieAwsResource data) {
        String keyname = "expressions";
        AWSUtils.getAwsResponse(() -> cloudSearchClient.describeExpressions((DescribeExpressionsRequest)DescribeExpressionsRequest.builder().domainName(domainStatus.domainName()).build()), resp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("expressions", resp)), noresp -> AWSUtils.update(data.supplementaryConfiguration, Map.of("expressions", noresp)));
    }

    private void discoverSize(DomainStatus domainStatus, MagpieAwsResource data, String account, MagpieAWSClientCreator clientCreator) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add((Dimension)Dimension.builder().name("DomainName").value(domainStatus.domainName()).build());
        dimensions.add((Dimension)Dimension.builder().name("ClientId").value(account).build());
        Pair<Double, GetMetricStatisticsResponse> IndexUtilization = AWSUtils.getCloudwatchDoubleMetricMaximum(data.awsRegion, "AWS/CloudSearch", "IndexUtilization", dimensions, clientCreator);
        Pair<Long, GetMetricStatisticsResponse> SearchableDocuments = AWSUtils.getCloudwatchMetricMaximum(data.awsRegion, "AWS/CloudSearch", "SearchableDocuments", dimensions, clientCreator);
        if (IndexUtilization.getValue0() != null && SearchableDocuments.getValue0() != null) {
            AWSUtils.update(data.supplementaryConfiguration, Map.of("indexUtilization", IndexUtilization.getValue0(), "searchableDocuments", SearchableDocuments.getValue0()));
        }
    }
}

