/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.aws.discovery;

import io.openraven.magpie.plugins.aws.discovery.MagpieAWSClientCreator;
import java.time.Instant;
import java.time.Period;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.BackupClientBuilder;
import software.amazon.awssdk.services.backup.model.BackupJob;
import software.amazon.awssdk.services.backup.model.BackupJobState;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;

public class BackupUtils {
    private static final Map<Region, BackupClient> CLIENTS = new ConcurrentHashMap<Region, BackupClient>();
    private static final Period HISTORY = Period.ofDays(45);

    public static List<BackupJob.Builder> listBackupJobs(String arn, Region region, MagpieAWSClientCreator clientCreator) {
        LinkedList<BackupJob.Builder> jobs = new LinkedList<BackupJob.Builder>();
        String nextToken = null;
        try (BackupClient client = (BackupClient)((BackupClientBuilder)((BackupClientBuilder)clientCreator.apply(BackupClient.builder())).region(region)).build();){
            ListBackupJobsResponse result;
            do {
                result = client.listBackupJobs((ListBackupJobsRequest)ListBackupJobsRequest.builder().byResourceArn(arn).byCreatedAfter(Instant.now().minus(HISTORY)).byState(BackupJobState.COMPLETED).nextToken(nextToken).build());
                jobs.addAll(result.backupJobs().stream().map(BackupJob::toBuilder).collect(Collectors.toList()));
            } while ((nextToken = result.nextToken()) != null);
        }
        return jobs;
    }
}

