/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openraven.magpie.api.utils.EncodedNamedUUIDGenerator;
import java.time.Instant;

public class MagpieAwsResource {
    private final ObjectMapper mapper;
    public String arn;
    public String resourceName;
    public String resourceId;
    public String resourceType;
    public String awsRegion;
    public String awsAccountId;
    public Instant createdIso;
    public Instant updatedIso = Instant.now();
    public String discoverySessionId;
    public Long maxSizeInBytes = null;
    public Long sizeInBytes = null;
    public JsonNode configuration;
    public JsonNode supplementaryConfiguration;
    public JsonNode tags;
    public JsonNode discoveryMeta;

    private MagpieAwsResource(MagpieAwsResourceBuilder builder) {
        this.arn = builder.arn;
        this.resourceName = builder.resourceName;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.awsRegion = builder.awsRegion;
        this.awsAccountId = builder.awsAccountId;
        this.createdIso = builder.createdIso;
        this.updatedIso = builder.updatedIso;
        this.discoverySessionId = builder.discoverySessionId;
        this.maxSizeInBytes = builder.maxSizeInBytes;
        this.sizeInBytes = builder.sizeInBytes;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
        this.tags = builder.tags;
        this.discoveryMeta = builder.discoveryMeta;
        this.mapper = builder.mapper;
    }

    public ObjectNode toJsonNode() {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("documentId", EncodedNamedUUIDGenerator.getEncodedNamedUUID(this.arn));
        data.put("arn", this.arn);
        data.put("resourceName", this.resourceName);
        data.put("resourceId", this.resourceId);
        data.put("resourceType", this.resourceType);
        data.put("awsRegion", this.awsRegion);
        data.put("awsAccountId", this.awsAccountId);
        data.put("createdIso", this.createdIso == null ? null : this.createdIso.toString());
        data.put("updatedIso", this.updatedIso == null ? null : this.updatedIso.toString());
        data.put("discoverySessionId", this.discoverySessionId);
        data.put("maxSizeInBytes", this.maxSizeInBytes);
        data.put("sizeInBytes", this.sizeInBytes);
        data.set("configuration", this.configuration);
        data.set("supplementaryConfiguration", this.supplementaryConfiguration);
        data.set("tags", this.tags);
        data.set("discoveryMeta", this.discoveryMeta);
        return data;
    }

    public String getArn() {
        return this.arn;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public Instant getCreatedIso() {
        return this.createdIso;
    }

    public void setCreatedIso(Instant createdIso) {
        this.createdIso = createdIso;
    }

    public Instant getUpdatedIso() {
        return this.updatedIso;
    }

    public void setUpdatedIso(Instant updatedIso) {
        this.updatedIso = updatedIso;
    }

    public String getDiscoverySessionId() {
        return this.discoverySessionId;
    }

    public void setDiscoverySessionId(String discoverySessionId) {
        this.discoverySessionId = discoverySessionId;
    }

    public Long getMaxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    public void setMaxSizeInBytes(Long maxSizeInBytes) {
        this.maxSizeInBytes = maxSizeInBytes;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    public JsonNode getSupplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public void setSupplementaryConfiguration(JsonNode supplementaryConfiguration) {
        this.supplementaryConfiguration = supplementaryConfiguration;
    }

    public JsonNode getTags() {
        return this.tags;
    }

    public void setTags(JsonNode tags) {
        this.tags = tags;
    }

    public JsonNode getDiscoveryMeta() {
        return this.discoveryMeta;
    }

    public void setDiscoveryMeta(JsonNode discoveryMeta) {
        this.discoveryMeta = discoveryMeta;
    }

    public static class MagpieAwsResourceBuilder {
        private final ObjectMapper mapper;
        private String arn;
        private String resourceName;
        private String resourceId;
        private String resourceType;
        private String awsRegion;
        private String awsAccountId;
        private Instant createdIso;
        private Instant updatedIso = Instant.now();
        private String discoverySessionId;
        private Long maxSizeInBytes = null;
        private Long sizeInBytes = null;
        private JsonNode configuration;
        private JsonNode supplementaryConfiguration;
        private JsonNode tags;
        private JsonNode discoveryMeta;

        public MagpieAwsResourceBuilder(ObjectMapper mapper, String arn) {
            this.arn = arn;
            this.mapper = mapper;
            this.configuration = mapper.createObjectNode();
            this.supplementaryConfiguration = mapper.createObjectNode();
            this.tags = mapper.createObjectNode();
            this.discoveryMeta = mapper.createObjectNode();
        }

        public MagpieAwsResourceBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public MagpieAwsResourceBuilder withResourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public MagpieAwsResourceBuilder withResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public MagpieAwsResourceBuilder withAwsRegion(String region) {
            this.awsRegion = region;
            return this;
        }

        public MagpieAwsResourceBuilder withAccountId(String accountId) {
            this.awsAccountId = accountId;
            return this;
        }

        public MagpieAwsResourceBuilder withCreatedIso(Instant createdIso) {
            this.createdIso = createdIso;
            return this;
        }

        public MagpieAwsResourceBuilder withUpdatedIso(Instant updatedIso) {
            this.updatedIso = updatedIso;
            return this;
        }

        public MagpieAwsResourceBuilder withDiscoverySessionId(String discoverySessionId) {
            this.discoverySessionId = discoverySessionId;
            return this;
        }

        public MagpieAwsResourceBuilder withMaxSizeInBytes(Long maxSizeInBytes) {
            this.maxSizeInBytes = maxSizeInBytes;
            return this;
        }

        public MagpieAwsResourceBuilder withSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public MagpieAwsResourceBuilder withConfiguration(JsonNode configuration) {
            this.configuration = configuration;
            return this;
        }

        public MagpieAwsResourceBuilder withSupplementaryConfiguration(JsonNode supplementaryConfiguration) {
            this.supplementaryConfiguration = supplementaryConfiguration;
            return this;
        }

        public MagpieAwsResourceBuilder withTags(JsonNode tags) {
            this.tags = tags;
            return this;
        }

        public MagpieAwsResourceBuilder withDiscoveryMeta(JsonNode discoveryMeta) {
            this.discoveryMeta = discoveryMeta;
            return this;
        }

        public MagpieAwsResource build() {
            return new MagpieAwsResource(this);
        }
    }
}

