/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openraven.magpie.api.utils.EncodedNamedUUIDGenerator;
import java.time.Instant;

public class MagpieGcpResource {
    private final ObjectMapper mapper;
    public String assetId;
    public String resourceName;
    public String resourceId;
    public String resourceType;
    public String region;
    public String projectId;
    public String gcpAccountId;
    public Instant createdIso;
    public Instant updatedIso = Instant.now();
    public String discoverySessionId;
    public Long maxSizeInBytes = null;
    public Long sizeInBytes = null;
    public JsonNode configuration;
    public JsonNode supplementaryConfiguration;
    public JsonNode tags;
    public JsonNode discoveryMeta;

    private MagpieGcpResource(MagpieGcpResourceBuilder builder) {
        this.assetId = builder.assetId;
        this.resourceName = builder.resourceName;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.projectId = builder.projectId;
        this.gcpAccountId = builder.gcpAccountId;
        this.region = builder.region;
        this.createdIso = builder.createdIso;
        this.updatedIso = builder.updatedIso;
        this.discoverySessionId = builder.discoverySessionId;
        this.maxSizeInBytes = builder.maxSizeInBytes;
        this.sizeInBytes = builder.sizeInBytes;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
        this.tags = builder.tags;
        this.discoveryMeta = builder.discoveryMeta;
        this.mapper = builder.mapper;
    }

    public ObjectNode toJsonNode() {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("documentId", EncodedNamedUUIDGenerator.getEncodedNamedUUID(this.assetId + this.resourceType + this.projectId));
        data.put("assetId", this.assetId);
        data.put("resourceName", this.resourceName);
        data.put("resourceId", this.resourceId);
        data.put("resourceType", this.resourceType);
        data.put("gcpAccountId", this.gcpAccountId);
        data.put("projectId", this.projectId);
        data.put("createdIso", this.createdIso == null ? null : this.createdIso.toString());
        data.put("updatedIso", this.updatedIso == null ? null : this.updatedIso.toString());
        data.put("discoverySessionId", this.discoverySessionId);
        data.put("maxSizeInBytes", this.maxSizeInBytes);
        data.put("sizeInBytes", this.sizeInBytes);
        data.set("configuration", this.configuration);
        data.set("supplementaryConfiguration", this.supplementaryConfiguration);
        data.set("tags", this.tags);
        data.set("discoveryMeta", this.discoveryMeta);
        return data;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getGcpAccountId() {
        return this.gcpAccountId;
    }

    public void setGcpAccountId(String gcpAccountId) {
        this.gcpAccountId = gcpAccountId;
    }

    public Instant getCreatedIso() {
        return this.createdIso;
    }

    public void setCreatedIso(Instant createdIso) {
        this.createdIso = createdIso;
    }

    public Instant getUpdatedIso() {
        return this.updatedIso;
    }

    public void setUpdatedIso(Instant updatedIso) {
        this.updatedIso = updatedIso;
    }

    public String getDiscoverySessionId() {
        return this.discoverySessionId;
    }

    public void setDiscoverySessionId(String discoverySessionId) {
        this.discoverySessionId = discoverySessionId;
    }

    public Long getMaxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    public void setMaxSizeInBytes(Long maxSizeInBytes) {
        this.maxSizeInBytes = maxSizeInBytes;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    public JsonNode getSupplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public void setSupplementaryConfiguration(JsonNode supplementaryConfiguration) {
        this.supplementaryConfiguration = supplementaryConfiguration;
    }

    public JsonNode getTags() {
        return this.tags;
    }

    public void setTags(JsonNode tags) {
        this.tags = tags;
    }

    public JsonNode getDiscoveryMeta() {
        return this.discoveryMeta;
    }

    public void setDiscoveryMeta(JsonNode discoveryMeta) {
        this.discoveryMeta = discoveryMeta;
    }

    public static class MagpieGcpResourceBuilder {
        private final ObjectMapper mapper;
        private String assetId;
        private String resourceName;
        private String resourceId;
        private String resourceType;
        private String region;
        private String projectId;
        private String gcpAccountId;
        private Instant createdIso;
        private Instant updatedIso = Instant.now();
        private String discoverySessionId;
        private Long maxSizeInBytes = null;
        private Long sizeInBytes = null;
        private JsonNode configuration;
        private JsonNode supplementaryConfiguration;
        private JsonNode tags;
        private JsonNode discoveryMeta;

        public MagpieGcpResourceBuilder(ObjectMapper mapper, String assetId) {
            this.assetId = assetId;
            this.mapper = mapper;
            this.configuration = mapper.createObjectNode();
            this.supplementaryConfiguration = mapper.createObjectNode();
            this.tags = mapper.createObjectNode();
            this.discoveryMeta = mapper.createObjectNode();
        }

        public MagpieGcpResourceBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public MagpieGcpResourceBuilder withResourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public MagpieGcpResourceBuilder withResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public MagpieGcpResourceBuilder withRegion(String region) {
            this.region = region;
            return this;
        }

        public MagpieGcpResourceBuilder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public MagpieGcpResourceBuilder withAccountId(String gcpAccountId) {
            this.gcpAccountId = gcpAccountId;
            return this;
        }

        public MagpieGcpResourceBuilder withCreatedIso(Instant createdIso) {
            this.createdIso = createdIso;
            return this;
        }

        public MagpieGcpResourceBuilder withUpdatedIso(Instant updatedIso) {
            this.updatedIso = updatedIso;
            return this;
        }

        public MagpieGcpResourceBuilder withDiscoverySessionId(String discoverySessionId) {
            this.discoverySessionId = discoverySessionId;
            return this;
        }

        public MagpieGcpResourceBuilder withMaxSizeInBytes(Long maxSizeInBytes) {
            this.maxSizeInBytes = maxSizeInBytes;
            return this;
        }

        public MagpieGcpResourceBuilder withSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public MagpieGcpResourceBuilder withConfiguration(JsonNode configuration) {
            this.configuration = configuration;
            return this;
        }

        public MagpieGcpResourceBuilder withSupplementaryConfiguration(JsonNode supplementaryConfiguration) {
            this.supplementaryConfiguration = supplementaryConfiguration;
            return this;
        }

        public MagpieGcpResourceBuilder withTags(JsonNode tags) {
            this.tags = tags;
            return this;
        }

        public MagpieGcpResourceBuilder withDiscoveryMeta(JsonNode discoveryMeta) {
            this.discoveryMeta = discoveryMeta;
            return this;
        }

        public MagpieGcpResource build() {
            return new MagpieGcpResource(this);
        }
    }
}

