/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openraven.magpie.api.utils.EncodedNamedUUIDGenerator;
import java.time.Instant;

public class MagpieAzureResource {
    private final ObjectMapper mapper;
    private final String containingEntity;
    private final String containingEntityId;
    public String resourceId;
    public String resourceName;
    public String resourceType;
    public String region;
    public String subscriptionId;
    public Instant createdIso;
    public Instant updatedIso = Instant.now();
    public String discoverySessionId;
    public Long maxSizeInBytes = null;
    public Long sizeInBytes = null;
    public JsonNode configuration;
    public JsonNode supplementaryConfiguration;
    public JsonNode tags;
    public JsonNode discoveryMeta;

    private MagpieAzureResource(MagpieAzureResourceBuilder builder) {
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.region = builder.region;
        this.subscriptionId = builder.subscriptionId;
        this.createdIso = builder.createdIso;
        this.updatedIso = builder.updatedIso;
        this.discoverySessionId = builder.discoverySessionId;
        this.maxSizeInBytes = builder.maxSizeInBytes;
        this.sizeInBytes = builder.sizeInBytes;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
        this.tags = builder.tags;
        this.discoveryMeta = builder.discoveryMeta;
        this.mapper = builder.mapper;
        this.containingEntity = builder.containingEntity;
        this.containingEntityId = builder.containingEntityId;
    }

    public ObjectNode toJsonNode() {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("documentId", EncodedNamedUUIDGenerator.getEncodedNamedUUID(this.resourceId));
        data.put("resourceId", this.resourceId);
        data.put("resourceName", this.resourceName);
        data.put("resourceId", this.resourceId);
        data.put("resourceType", this.resourceType);
        data.put("region", this.region);
        data.put("subscriptionId", this.subscriptionId);
        data.put("createdIso", this.createdIso == null ? null : this.createdIso.toString());
        data.put("updatedIso", this.updatedIso == null ? null : this.updatedIso.toString());
        data.put("discoverySessionId", this.discoverySessionId);
        data.put("maxSizeInBytes", this.maxSizeInBytes);
        data.put("sizeInBytes", this.sizeInBytes);
        data.put("containingEntity", this.containingEntity);
        data.put("containingEntityId", this.containingEntityId);
        data.set("configuration", this.configuration);
        data.set("supplementaryConfiguration", this.supplementaryConfiguration);
        data.set("tags", this.tags);
        data.set("discoveryMeta", this.discoveryMeta);
        return data;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public Instant getCreatedIso() {
        return this.createdIso;
    }

    public void setCreatedIso(Instant createdIso) {
        this.createdIso = createdIso;
    }

    public Instant getUpdatedIso() {
        return this.updatedIso;
    }

    public void setUpdatedIso(Instant updatedIso) {
        this.updatedIso = updatedIso;
    }

    public String getDiscoverySessionId() {
        return this.discoverySessionId;
    }

    public void setDiscoverySessionId(String discoverySessionId) {
        this.discoverySessionId = discoverySessionId;
    }

    public Long getMaxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    public void setMaxSizeInBytes(Long maxSizeInBytes) {
        this.maxSizeInBytes = maxSizeInBytes;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    public JsonNode getSupplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public void setSupplementaryConfiguration(JsonNode supplementaryConfiguration) {
        this.supplementaryConfiguration = supplementaryConfiguration;
    }

    public JsonNode getTags() {
        return this.tags;
    }

    public void setTags(JsonNode tags) {
        this.tags = tags;
    }

    public JsonNode getDiscoveryMeta() {
        return this.discoveryMeta;
    }

    public void setDiscoveryMeta(JsonNode discoveryMeta) {
        this.discoveryMeta = discoveryMeta;
    }

    public String getContainingEntity() {
        return this.containingEntity;
    }

    public String getContainingEntityId() {
        return this.containingEntityId;
    }

    public static class MagpieAzureResourceBuilder {
        private final ObjectMapper mapper;
        private String resourceName;
        private String resourceId;
        private String resourceType;
        private String region;
        private String subscriptionId;
        private Instant createdIso;
        private Instant updatedIso = Instant.now();
        private String discoverySessionId;
        private Long maxSizeInBytes = null;
        private Long sizeInBytes = null;
        private JsonNode configuration;
        private JsonNode supplementaryConfiguration;
        private JsonNode tags;
        private JsonNode discoveryMeta;
        private String containingEntityId;
        private String containingEntity;

        public MagpieAzureResourceBuilder(ObjectMapper mapper, String resourceId) {
            this.resourceId = resourceId;
            this.mapper = mapper;
            this.configuration = mapper.createObjectNode();
            this.supplementaryConfiguration = mapper.createObjectNode();
            this.tags = mapper.createObjectNode();
            this.discoveryMeta = mapper.createObjectNode();
        }

        public MagpieAzureResourceBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public MagpieAzureResourceBuilder withResourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public MagpieAzureResourceBuilder withResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public MagpieAzureResourceBuilder withRegion(String region) {
            this.region = region;
            return this;
        }

        public MagpieAzureResourceBuilder withsubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public MagpieAzureResourceBuilder withCreatedIso(Instant createdIso) {
            this.createdIso = createdIso;
            return this;
        }

        public MagpieAzureResourceBuilder withUpdatedIso(Instant updatedIso) {
            this.updatedIso = updatedIso;
            return this;
        }

        public MagpieAzureResourceBuilder withDiscoverySessionId(String discoverySessionId) {
            this.discoverySessionId = discoverySessionId;
            return this;
        }

        public MagpieAzureResourceBuilder withMaxSizeInBytes(Long maxSizeInBytes) {
            this.maxSizeInBytes = maxSizeInBytes;
            return this;
        }

        public MagpieAzureResourceBuilder withSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public MagpieAzureResourceBuilder withConfiguration(JsonNode configuration) {
            this.configuration = configuration;
            return this;
        }

        public MagpieAzureResourceBuilder withSupplementaryConfiguration(JsonNode supplementaryConfiguration) {
            this.supplementaryConfiguration = supplementaryConfiguration;
            return this;
        }

        public MagpieAzureResourceBuilder withTags(JsonNode tags) {
            this.tags = tags;
            return this;
        }

        public MagpieAzureResourceBuilder withDiscoveryMeta(JsonNode discoveryMeta) {
            this.discoveryMeta = discoveryMeta;
            return this;
        }

        public MagpieAzureResource build() {
            return new MagpieAzureResource(this);
        }

        public MagpieAzureResourceBuilder withContainingEntity(String s) {
            this.containingEntity = s;
            return this;
        }

        public MagpieAzureResourceBuilder withContainingEntityId(String s) {
            this.containingEntityId = s;
            return this;
        }
    }
}

