/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.ui;

import io.obswebsocket.community.client.message.response.RequestResponse;
import io.obswebsocket.community.client.model.Monitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetMonitorListResponse
extends RequestResponse<SpecificData> {
    public List<Monitor> getMonitors() {
        return ((SpecificData)this.getMessageData().getResponseData()).getMonitors();
    }

    @Override
    public String toString() {
        return "GetMonitorListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<Monitor> monitors;

        SpecificData(List<Monitor> monitors) {
            this.monitors = monitors;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<Monitor> getMonitors() {
            return this.monitors;
        }

        public String toString() {
            return "GetMonitorListResponse.SpecificData(monitors=" + this.getMonitors() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<Monitor> monitors;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder monitor(Monitor monitor) {
                if (this.monitors == null) {
                    this.monitors = new ArrayList();
                }
                this.monitors.add(monitor);
                return this;
            }

            public SpecificDataBuilder monitors(Collection<? extends Monitor> monitors) {
                if (monitors == null) {
                    throw new IllegalArgumentException("monitors cannot be null");
                }
                if (this.monitors == null) {
                    this.monitors = new ArrayList();
                }
                this.monitors.addAll(monitors);
                return this;
            }

            public SpecificDataBuilder clearMonitors() {
                if (this.monitors != null) {
                    this.monitors.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<Monitor> monitors;
                switch (this.monitors == null ? 0 : this.monitors.size()) {
                    case 0: {
                        monitors = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        monitors = Collections.singletonList(this.monitors.get(0));
                        break;
                    }
                    default: {
                        monitors = Collections.unmodifiableList(new ArrayList<Monitor>(this.monitors));
                    }
                }
                return new SpecificData(monitors);
            }

            public String toString() {
                return "GetMonitorListResponse.SpecificData.SpecificDataBuilder(monitors=" + this.monitors + ")";
            }
        }
    }
}

