/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.transitions;

import io.obswebsocket.community.client.message.response.RequestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetTransitionKindListResponse
extends RequestResponse<SpecificData> {
    public List<String> getTransitionKinds() {
        return ((SpecificData)this.getMessageData().getResponseData()).getTransitionKinds();
    }

    @Override
    public String toString() {
        return "GetTransitionKindListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<String> transitionKinds;

        SpecificData(List<String> transitionKinds) {
            this.transitionKinds = transitionKinds;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<String> getTransitionKinds() {
            return this.transitionKinds;
        }

        public String toString() {
            return "GetTransitionKindListResponse.SpecificData(transitionKinds=" + this.getTransitionKinds() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<String> transitionKinds;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder transitionKind(String transitionKind) {
                if (this.transitionKinds == null) {
                    this.transitionKinds = new ArrayList();
                }
                this.transitionKinds.add(transitionKind);
                return this;
            }

            public SpecificDataBuilder transitionKinds(Collection<? extends String> transitionKinds) {
                if (transitionKinds == null) {
                    throw new IllegalArgumentException("transitionKinds cannot be null");
                }
                if (this.transitionKinds == null) {
                    this.transitionKinds = new ArrayList();
                }
                this.transitionKinds.addAll(transitionKinds);
                return this;
            }

            public SpecificDataBuilder clearTransitionKinds() {
                if (this.transitionKinds != null) {
                    this.transitionKinds.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<String> transitionKinds;
                switch (this.transitionKinds == null ? 0 : this.transitionKinds.size()) {
                    case 0: {
                        transitionKinds = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        transitionKinds = Collections.singletonList(this.transitionKinds.get(0));
                        break;
                    }
                    default: {
                        transitionKinds = Collections.unmodifiableList(new ArrayList<String>(this.transitionKinds));
                    }
                }
                return new SpecificData(transitionKinds);
            }

            public String toString() {
                return "GetTransitionKindListResponse.SpecificData.SpecificDataBuilder(transitionKinds=" + this.transitionKinds + ")";
            }
        }
    }
}

