/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.scenes;

import io.obswebsocket.community.client.message.response.RequestResponse;
import io.obswebsocket.community.client.model.Scene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetSceneListResponse
extends RequestResponse<SpecificData> {
    public String getCurrentProgramSceneName() {
        return ((SpecificData)this.getMessageData().getResponseData()).getCurrentProgramSceneName();
    }

    public String getCurrentPreviewSceneName() {
        return ((SpecificData)this.getMessageData().getResponseData()).getCurrentPreviewSceneName();
    }

    public List<Scene> getScenes() {
        return ((SpecificData)this.getMessageData().getResponseData()).getScenes();
    }

    @Override
    public String toString() {
        return "GetSceneListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private String currentProgramSceneName;
        private String currentPreviewSceneName;
        private List<Scene> scenes;

        SpecificData(String currentProgramSceneName, String currentPreviewSceneName, List<Scene> scenes) {
            this.currentProgramSceneName = currentProgramSceneName;
            this.currentPreviewSceneName = currentPreviewSceneName;
            this.scenes = scenes;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public String getCurrentProgramSceneName() {
            return this.currentProgramSceneName;
        }

        public String getCurrentPreviewSceneName() {
            return this.currentPreviewSceneName;
        }

        public List<Scene> getScenes() {
            return this.scenes;
        }

        public String toString() {
            return "GetSceneListResponse.SpecificData(currentProgramSceneName=" + this.getCurrentProgramSceneName() + ", currentPreviewSceneName=" + this.getCurrentPreviewSceneName() + ", scenes=" + this.getScenes() + ")";
        }

        public static class SpecificDataBuilder {
            private String currentProgramSceneName;
            private String currentPreviewSceneName;
            private ArrayList<Scene> scenes;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder currentProgramSceneName(String currentProgramSceneName) {
                this.currentProgramSceneName = currentProgramSceneName;
                return this;
            }

            public SpecificDataBuilder currentPreviewSceneName(String currentPreviewSceneName) {
                this.currentPreviewSceneName = currentPreviewSceneName;
                return this;
            }

            public SpecificDataBuilder scene(Scene scene) {
                if (this.scenes == null) {
                    this.scenes = new ArrayList();
                }
                this.scenes.add(scene);
                return this;
            }

            public SpecificDataBuilder scenes(Collection<? extends Scene> scenes) {
                if (scenes == null) {
                    throw new IllegalArgumentException("scenes cannot be null");
                }
                if (this.scenes == null) {
                    this.scenes = new ArrayList();
                }
                this.scenes.addAll(scenes);
                return this;
            }

            public SpecificDataBuilder clearScenes() {
                if (this.scenes != null) {
                    this.scenes.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<Scene> scenes;
                switch (this.scenes == null ? 0 : this.scenes.size()) {
                    case 0: {
                        scenes = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        scenes = Collections.singletonList(this.scenes.get(0));
                        break;
                    }
                    default: {
                        scenes = Collections.unmodifiableList(new ArrayList<Scene>(this.scenes));
                    }
                }
                return new SpecificData(this.currentProgramSceneName, this.currentPreviewSceneName, scenes);
            }

            public String toString() {
                return "GetSceneListResponse.SpecificData.SpecificDataBuilder(currentProgramSceneName=" + this.currentProgramSceneName + ", currentPreviewSceneName=" + this.currentPreviewSceneName + ", scenes=" + this.scenes + ")";
            }
        }
    }
}

