/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.scenes;

import io.obswebsocket.community.client.message.response.RequestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetGroupListResponse
extends RequestResponse<SpecificData> {
    public List<String> getGroups() {
        return ((SpecificData)this.getMessageData().getResponseData()).getGroups();
    }

    @Override
    public String toString() {
        return "GetGroupListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<String> groups;

        SpecificData(List<String> groups) {
            this.groups = groups;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public String toString() {
            return "GetGroupListResponse.SpecificData(groups=" + this.getGroups() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<String> groups;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder group(String group) {
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                this.groups.add(group);
                return this;
            }

            public SpecificDataBuilder groups(Collection<? extends String> groups) {
                if (groups == null) {
                    throw new IllegalArgumentException("groups cannot be null");
                }
                if (this.groups == null) {
                    this.groups = new ArrayList();
                }
                this.groups.addAll(groups);
                return this;
            }

            public SpecificDataBuilder clearGroups() {
                if (this.groups != null) {
                    this.groups.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<String> groups;
                switch (this.groups == null ? 0 : this.groups.size()) {
                    case 0: {
                        groups = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        groups = Collections.singletonList(this.groups.get(0));
                        break;
                    }
                    default: {
                        groups = Collections.unmodifiableList(new ArrayList<String>(this.groups));
                    }
                }
                return new SpecificData(groups);
            }

            public String toString() {
                return "GetGroupListResponse.SpecificData.SpecificDataBuilder(groups=" + this.groups + ")";
            }
        }
    }
}

