/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.sceneitems;

import io.obswebsocket.community.client.message.response.RequestResponse;
import io.obswebsocket.community.client.model.SceneItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetGroupSceneItemListResponse
extends RequestResponse<SpecificData> {
    public List<SceneItem> getSceneItems() {
        return ((SpecificData)this.getMessageData().getResponseData()).getSceneItems();
    }

    @Override
    public String toString() {
        return "GetGroupSceneItemListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<SceneItem> sceneItems;

        SpecificData(List<SceneItem> sceneItems) {
            this.sceneItems = sceneItems;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<SceneItem> getSceneItems() {
            return this.sceneItems;
        }

        public String toString() {
            return "GetGroupSceneItemListResponse.SpecificData(sceneItems=" + this.getSceneItems() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<SceneItem> sceneItems;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneItem(SceneItem sceneItem) {
                if (this.sceneItems == null) {
                    this.sceneItems = new ArrayList();
                }
                this.sceneItems.add(sceneItem);
                return this;
            }

            public SpecificDataBuilder sceneItems(Collection<? extends SceneItem> sceneItems) {
                if (sceneItems == null) {
                    throw new IllegalArgumentException("sceneItems cannot be null");
                }
                if (this.sceneItems == null) {
                    this.sceneItems = new ArrayList();
                }
                this.sceneItems.addAll(sceneItems);
                return this;
            }

            public SpecificDataBuilder clearSceneItems() {
                if (this.sceneItems != null) {
                    this.sceneItems.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<SceneItem> sceneItems;
                switch (this.sceneItems == null ? 0 : this.sceneItems.size()) {
                    case 0: {
                        sceneItems = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sceneItems = Collections.singletonList(this.sceneItems.get(0));
                        break;
                    }
                    default: {
                        sceneItems = Collections.unmodifiableList(new ArrayList<SceneItem>(this.sceneItems));
                    }
                }
                return new SpecificData(sceneItems);
            }

            public String toString() {
                return "GetGroupSceneItemListResponse.SpecificData.SpecificDataBuilder(sceneItems=" + this.sceneItems + ")";
            }
        }
    }
}

