/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.outputs;

import io.obswebsocket.community.client.message.response.RequestResponse;
import io.obswebsocket.community.client.model.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetOutputListResponse
extends RequestResponse<SpecificData> {
    public List<Output> getOutputs() {
        return ((SpecificData)this.getMessageData().getResponseData()).getOutputs();
    }

    @Override
    public String toString() {
        return "GetOutputListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<Output> outputs;

        SpecificData(List<Output> outputs) {
            this.outputs = outputs;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<Output> getOutputs() {
            return this.outputs;
        }

        public String toString() {
            return "GetOutputListResponse.SpecificData(outputs=" + this.getOutputs() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<Output> outputs;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder output(Output output) {
                if (this.outputs == null) {
                    this.outputs = new ArrayList();
                }
                this.outputs.add(output);
                return this;
            }

            public SpecificDataBuilder outputs(Collection<? extends Output> outputs) {
                if (outputs == null) {
                    throw new IllegalArgumentException("outputs cannot be null");
                }
                if (this.outputs == null) {
                    this.outputs = new ArrayList();
                }
                this.outputs.addAll(outputs);
                return this;
            }

            public SpecificDataBuilder clearOutputs() {
                if (this.outputs != null) {
                    this.outputs.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<Output> outputs;
                switch (this.outputs == null ? 0 : this.outputs.size()) {
                    case 0: {
                        outputs = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        outputs = Collections.singletonList(this.outputs.get(0));
                        break;
                    }
                    default: {
                        outputs = Collections.unmodifiableList(new ArrayList<Output>(this.outputs));
                    }
                }
                return new SpecificData(outputs);
            }

            public String toString() {
                return "GetOutputListResponse.SpecificData.SpecificDataBuilder(outputs=" + this.outputs + ")";
            }
        }
    }
}

