/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.inputs;

import io.obswebsocket.community.client.message.response.RequestResponse;
import io.obswebsocket.community.client.model.Input;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetInputPropertiesListPropertyItemsResponse
extends RequestResponse<SpecificData> {
    public List<Input.PropertyItem> getPropertyItems() {
        return ((SpecificData)this.getMessageData().getResponseData()).getPropertyItems();
    }

    @Override
    public String toString() {
        return "GetInputPropertiesListPropertyItemsResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<Input.PropertyItem> propertyItems;

        SpecificData(List<Input.PropertyItem> propertyItems) {
            this.propertyItems = propertyItems;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<Input.PropertyItem> getPropertyItems() {
            return this.propertyItems;
        }

        public String toString() {
            return "GetInputPropertiesListPropertyItemsResponse.SpecificData(propertyItems=" + this.getPropertyItems() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<Input.PropertyItem> propertyItems;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder propertyItem(Input.PropertyItem propertyItem) {
                if (this.propertyItems == null) {
                    this.propertyItems = new ArrayList();
                }
                this.propertyItems.add(propertyItem);
                return this;
            }

            public SpecificDataBuilder propertyItems(Collection<? extends Input.PropertyItem> propertyItems) {
                if (propertyItems == null) {
                    throw new IllegalArgumentException("propertyItems cannot be null");
                }
                if (this.propertyItems == null) {
                    this.propertyItems = new ArrayList();
                }
                this.propertyItems.addAll(propertyItems);
                return this;
            }

            public SpecificDataBuilder clearPropertyItems() {
                if (this.propertyItems != null) {
                    this.propertyItems.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<Input.PropertyItem> propertyItems;
                switch (this.propertyItems == null ? 0 : this.propertyItems.size()) {
                    case 0: {
                        propertyItems = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        propertyItems = Collections.singletonList(this.propertyItems.get(0));
                        break;
                    }
                    default: {
                        propertyItems = Collections.unmodifiableList(new ArrayList<Input.PropertyItem>(this.propertyItems));
                    }
                }
                return new SpecificData(propertyItems);
            }

            public String toString() {
                return "GetInputPropertiesListPropertyItemsResponse.SpecificData.SpecificDataBuilder(propertyItems=" + this.propertyItems + ")";
            }
        }
    }
}

