/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.inputs;

import io.obswebsocket.community.client.message.response.RequestResponse;
import io.obswebsocket.community.client.model.Input;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetInputListResponse
extends RequestResponse<SpecificData> {
    public List<Input> getInputs() {
        return ((SpecificData)this.getMessageData().getResponseData()).getInputs();
    }

    @Override
    public String toString() {
        return "GetInputListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<Input> inputs;

        SpecificData(List<Input> inputs) {
            this.inputs = inputs;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<Input> getInputs() {
            return this.inputs;
        }

        public String toString() {
            return "GetInputListResponse.SpecificData(inputs=" + this.getInputs() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<Input> inputs;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder input(Input input) {
                if (this.inputs == null) {
                    this.inputs = new ArrayList();
                }
                this.inputs.add(input);
                return this;
            }

            public SpecificDataBuilder inputs(Collection<? extends Input> inputs) {
                if (inputs == null) {
                    throw new IllegalArgumentException("inputs cannot be null");
                }
                if (this.inputs == null) {
                    this.inputs = new ArrayList();
                }
                this.inputs.addAll(inputs);
                return this;
            }

            public SpecificDataBuilder clearInputs() {
                if (this.inputs != null) {
                    this.inputs.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<Input> inputs;
                switch (this.inputs == null ? 0 : this.inputs.size()) {
                    case 0: {
                        inputs = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        inputs = Collections.singletonList(this.inputs.get(0));
                        break;
                    }
                    default: {
                        inputs = Collections.unmodifiableList(new ArrayList<Input>(this.inputs));
                    }
                }
                return new SpecificData(inputs);
            }

            public String toString() {
                return "GetInputListResponse.SpecificData.SpecificDataBuilder(inputs=" + this.inputs + ")";
            }
        }
    }
}

