/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.inputs;

import io.obswebsocket.community.client.message.response.RequestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetInputKindListResponse
extends RequestResponse<SpecificData> {
    public List<String> getInputKinds() {
        return ((SpecificData)this.getMessageData().getResponseData()).getInputKinds();
    }

    @Override
    public String toString() {
        return "GetInputKindListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<String> inputKinds;

        SpecificData(List<String> inputKinds) {
            this.inputKinds = inputKinds;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<String> getInputKinds() {
            return this.inputKinds;
        }

        public String toString() {
            return "GetInputKindListResponse.SpecificData(inputKinds=" + this.getInputKinds() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<String> inputKinds;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder inputKind(String inputKind) {
                if (this.inputKinds == null) {
                    this.inputKinds = new ArrayList();
                }
                this.inputKinds.add(inputKind);
                return this;
            }

            public SpecificDataBuilder inputKinds(Collection<? extends String> inputKinds) {
                if (inputKinds == null) {
                    throw new IllegalArgumentException("inputKinds cannot be null");
                }
                if (this.inputKinds == null) {
                    this.inputKinds = new ArrayList();
                }
                this.inputKinds.addAll(inputKinds);
                return this;
            }

            public SpecificDataBuilder clearInputKinds() {
                if (this.inputKinds != null) {
                    this.inputKinds.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<String> inputKinds;
                switch (this.inputKinds == null ? 0 : this.inputKinds.size()) {
                    case 0: {
                        inputKinds = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        inputKinds = Collections.singletonList(this.inputKinds.get(0));
                        break;
                    }
                    default: {
                        inputKinds = Collections.unmodifiableList(new ArrayList<String>(this.inputKinds));
                    }
                }
                return new SpecificData(inputKinds);
            }

            public String toString() {
                return "GetInputKindListResponse.SpecificData.SpecificDataBuilder(inputKinds=" + this.inputKinds + ")";
            }
        }
    }
}

