/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.general;

import io.obswebsocket.community.client.message.response.RequestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetVersionResponse
extends RequestResponse<SpecificData> {
    public String getObsVersion() {
        return ((SpecificData)this.getMessageData().getResponseData()).getObsVersion();
    }

    public String getObsWebSocketVersion() {
        return ((SpecificData)this.getMessageData().getResponseData()).getObsWebSocketVersion();
    }

    public Number getRpcVersion() {
        return ((SpecificData)this.getMessageData().getResponseData()).getRpcVersion();
    }

    public List<String> getAvailableRequests() {
        return ((SpecificData)this.getMessageData().getResponseData()).getAvailableRequests();
    }

    public List<String> getSupportedImageFormats() {
        return ((SpecificData)this.getMessageData().getResponseData()).getSupportedImageFormats();
    }

    public String getPlatform() {
        return ((SpecificData)this.getMessageData().getResponseData()).getPlatform();
    }

    public String getPlatformDescription() {
        return ((SpecificData)this.getMessageData().getResponseData()).getPlatformDescription();
    }

    @Override
    public String toString() {
        return "GetVersionResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private String obsVersion;
        private String obsWebSocketVersion;
        private Number rpcVersion;
        private List<String> availableRequests;
        private List<String> supportedImageFormats;
        private String platform;
        private String platformDescription;

        SpecificData(String obsVersion, String obsWebSocketVersion, Number rpcVersion, List<String> availableRequests, List<String> supportedImageFormats, String platform, String platformDescription) {
            this.obsVersion = obsVersion;
            this.obsWebSocketVersion = obsWebSocketVersion;
            this.rpcVersion = rpcVersion;
            this.availableRequests = availableRequests;
            this.supportedImageFormats = supportedImageFormats;
            this.platform = platform;
            this.platformDescription = platformDescription;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public String getObsVersion() {
            return this.obsVersion;
        }

        public String getObsWebSocketVersion() {
            return this.obsWebSocketVersion;
        }

        public Number getRpcVersion() {
            return this.rpcVersion;
        }

        public List<String> getAvailableRequests() {
            return this.availableRequests;
        }

        public List<String> getSupportedImageFormats() {
            return this.supportedImageFormats;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getPlatformDescription() {
            return this.platformDescription;
        }

        public String toString() {
            return "GetVersionResponse.SpecificData(obsVersion=" + this.getObsVersion() + ", obsWebSocketVersion=" + this.getObsWebSocketVersion() + ", rpcVersion=" + this.getRpcVersion() + ", availableRequests=" + this.getAvailableRequests() + ", supportedImageFormats=" + this.getSupportedImageFormats() + ", platform=" + this.getPlatform() + ", platformDescription=" + this.getPlatformDescription() + ")";
        }

        public static class SpecificDataBuilder {
            private String obsVersion;
            private String obsWebSocketVersion;
            private Number rpcVersion;
            private ArrayList<String> availableRequests;
            private ArrayList<String> supportedImageFormats;
            private String platform;
            private String platformDescription;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder obsVersion(String obsVersion) {
                this.obsVersion = obsVersion;
                return this;
            }

            public SpecificDataBuilder obsWebSocketVersion(String obsWebSocketVersion) {
                this.obsWebSocketVersion = obsWebSocketVersion;
                return this;
            }

            public SpecificDataBuilder rpcVersion(Number rpcVersion) {
                this.rpcVersion = rpcVersion;
                return this;
            }

            public SpecificDataBuilder availableRequest(String availableRequest) {
                if (this.availableRequests == null) {
                    this.availableRequests = new ArrayList();
                }
                this.availableRequests.add(availableRequest);
                return this;
            }

            public SpecificDataBuilder availableRequests(Collection<? extends String> availableRequests) {
                if (availableRequests == null) {
                    throw new IllegalArgumentException("availableRequests cannot be null");
                }
                if (this.availableRequests == null) {
                    this.availableRequests = new ArrayList();
                }
                this.availableRequests.addAll(availableRequests);
                return this;
            }

            public SpecificDataBuilder clearAvailableRequests() {
                if (this.availableRequests != null) {
                    this.availableRequests.clear();
                }
                return this;
            }

            public SpecificDataBuilder supportedImageFormat(String supportedImageFormat) {
                if (this.supportedImageFormats == null) {
                    this.supportedImageFormats = new ArrayList();
                }
                this.supportedImageFormats.add(supportedImageFormat);
                return this;
            }

            public SpecificDataBuilder supportedImageFormats(Collection<? extends String> supportedImageFormats) {
                if (supportedImageFormats == null) {
                    throw new IllegalArgumentException("supportedImageFormats cannot be null");
                }
                if (this.supportedImageFormats == null) {
                    this.supportedImageFormats = new ArrayList();
                }
                this.supportedImageFormats.addAll(supportedImageFormats);
                return this;
            }

            public SpecificDataBuilder clearSupportedImageFormats() {
                if (this.supportedImageFormats != null) {
                    this.supportedImageFormats.clear();
                }
                return this;
            }

            public SpecificDataBuilder platform(String platform) {
                this.platform = platform;
                return this;
            }

            public SpecificDataBuilder platformDescription(String platformDescription) {
                this.platformDescription = platformDescription;
                return this;
            }

            public SpecificData build() {
                List<String> supportedImageFormats;
                List<String> availableRequests;
                switch (this.availableRequests == null ? 0 : this.availableRequests.size()) {
                    case 0: {
                        availableRequests = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        availableRequests = Collections.singletonList(this.availableRequests.get(0));
                        break;
                    }
                    default: {
                        availableRequests = Collections.unmodifiableList(new ArrayList<String>(this.availableRequests));
                    }
                }
                switch (this.supportedImageFormats == null ? 0 : this.supportedImageFormats.size()) {
                    case 0: {
                        supportedImageFormats = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        supportedImageFormats = Collections.singletonList(this.supportedImageFormats.get(0));
                        break;
                    }
                    default: {
                        supportedImageFormats = Collections.unmodifiableList(new ArrayList<String>(this.supportedImageFormats));
                    }
                }
                return new SpecificData(this.obsVersion, this.obsWebSocketVersion, this.rpcVersion, availableRequests, supportedImageFormats, this.platform, this.platformDescription);
            }

            public String toString() {
                return "GetVersionResponse.SpecificData.SpecificDataBuilder(obsVersion=" + this.obsVersion + ", obsWebSocketVersion=" + this.obsWebSocketVersion + ", rpcVersion=" + this.rpcVersion + ", availableRequests=" + this.availableRequests + ", supportedImageFormats=" + this.supportedImageFormats + ", platform=" + this.platform + ", platformDescription=" + this.platformDescription + ")";
            }
        }
    }
}

