/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.general;

import io.obswebsocket.community.client.message.response.RequestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetHotkeyListResponse
extends RequestResponse<SpecificData> {
    public List<String> getHotkeys() {
        return ((SpecificData)this.getMessageData().getResponseData()).getHotkeys();
    }

    @Override
    public String toString() {
        return "GetHotkeyListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<String> hotkeys;

        SpecificData(List<String> hotkeys) {
            this.hotkeys = hotkeys;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<String> getHotkeys() {
            return this.hotkeys;
        }

        public String toString() {
            return "GetHotkeyListResponse.SpecificData(hotkeys=" + this.getHotkeys() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<String> hotkeys;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder hotkey(String hotkey) {
                if (this.hotkeys == null) {
                    this.hotkeys = new ArrayList();
                }
                this.hotkeys.add(hotkey);
                return this;
            }

            public SpecificDataBuilder hotkeys(Collection<? extends String> hotkeys) {
                if (hotkeys == null) {
                    throw new IllegalArgumentException("hotkeys cannot be null");
                }
                if (this.hotkeys == null) {
                    this.hotkeys = new ArrayList();
                }
                this.hotkeys.addAll(hotkeys);
                return this;
            }

            public SpecificDataBuilder clearHotkeys() {
                if (this.hotkeys != null) {
                    this.hotkeys.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<String> hotkeys;
                switch (this.hotkeys == null ? 0 : this.hotkeys.size()) {
                    case 0: {
                        hotkeys = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        hotkeys = Collections.singletonList(this.hotkeys.get(0));
                        break;
                    }
                    default: {
                        hotkeys = Collections.unmodifiableList(new ArrayList<String>(this.hotkeys));
                    }
                }
                return new SpecificData(hotkeys);
            }

            public String toString() {
                return "GetHotkeyListResponse.SpecificData.SpecificDataBuilder(hotkeys=" + this.hotkeys + ")";
            }
        }
    }
}

