/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.filters;

import io.obswebsocket.community.client.message.response.RequestResponse;
import io.obswebsocket.community.client.model.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetSourceFilterListResponse
extends RequestResponse<SpecificData> {
    public List<Filter> getFilters() {
        return ((SpecificData)this.getMessageData().getResponseData()).getFilters();
    }

    @Override
    public String toString() {
        return "GetSourceFilterListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<Filter> filters;

        SpecificData(List<Filter> filters) {
            this.filters = filters;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public String toString() {
            return "GetSourceFilterListResponse.SpecificData(filters=" + this.getFilters() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<Filter> filters;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder filter(Filter filter) {
                if (this.filters == null) {
                    this.filters = new ArrayList();
                }
                this.filters.add(filter);
                return this;
            }

            public SpecificDataBuilder filters(Collection<? extends Filter> filters) {
                if (filters == null) {
                    throw new IllegalArgumentException("filters cannot be null");
                }
                if (this.filters == null) {
                    this.filters = new ArrayList();
                }
                this.filters.addAll(filters);
                return this;
            }

            public SpecificDataBuilder clearFilters() {
                if (this.filters != null) {
                    this.filters.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<Filter> filters;
                switch (this.filters == null ? 0 : this.filters.size()) {
                    case 0: {
                        filters = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        filters = Collections.singletonList(this.filters.get(0));
                        break;
                    }
                    default: {
                        filters = Collections.unmodifiableList(new ArrayList<Filter>(this.filters));
                    }
                }
                return new SpecificData(filters);
            }

            public String toString() {
                return "GetSourceFilterListResponse.SpecificData.SpecificDataBuilder(filters=" + this.filters + ")";
            }
        }
    }
}

