/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.config;

import io.obswebsocket.community.client.message.response.RequestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetSceneCollectionListResponse
extends RequestResponse<SpecificData> {
    public String getCurrentSceneCollectionName() {
        return ((SpecificData)this.getMessageData().getResponseData()).getCurrentSceneCollectionName();
    }

    public List<String> getSceneCollections() {
        return ((SpecificData)this.getMessageData().getResponseData()).getSceneCollections();
    }

    @Override
    public String toString() {
        return "GetSceneCollectionListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private String currentSceneCollectionName;
        private List<String> sceneCollections;

        SpecificData(String currentSceneCollectionName, List<String> sceneCollections) {
            this.currentSceneCollectionName = currentSceneCollectionName;
            this.sceneCollections = sceneCollections;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public String getCurrentSceneCollectionName() {
            return this.currentSceneCollectionName;
        }

        public List<String> getSceneCollections() {
            return this.sceneCollections;
        }

        public String toString() {
            return "GetSceneCollectionListResponse.SpecificData(currentSceneCollectionName=" + this.getCurrentSceneCollectionName() + ", sceneCollections=" + this.getSceneCollections() + ")";
        }

        public static class SpecificDataBuilder {
            private String currentSceneCollectionName;
            private ArrayList<String> sceneCollections;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder currentSceneCollectionName(String currentSceneCollectionName) {
                this.currentSceneCollectionName = currentSceneCollectionName;
                return this;
            }

            public SpecificDataBuilder sceneCollection(String sceneCollection) {
                if (this.sceneCollections == null) {
                    this.sceneCollections = new ArrayList();
                }
                this.sceneCollections.add(sceneCollection);
                return this;
            }

            public SpecificDataBuilder sceneCollections(Collection<? extends String> sceneCollections) {
                if (sceneCollections == null) {
                    throw new IllegalArgumentException("sceneCollections cannot be null");
                }
                if (this.sceneCollections == null) {
                    this.sceneCollections = new ArrayList();
                }
                this.sceneCollections.addAll(sceneCollections);
                return this;
            }

            public SpecificDataBuilder clearSceneCollections() {
                if (this.sceneCollections != null) {
                    this.sceneCollections.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<String> sceneCollections;
                switch (this.sceneCollections == null ? 0 : this.sceneCollections.size()) {
                    case 0: {
                        sceneCollections = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sceneCollections = Collections.singletonList(this.sceneCollections.get(0));
                        break;
                    }
                    default: {
                        sceneCollections = Collections.unmodifiableList(new ArrayList<String>(this.sceneCollections));
                    }
                }
                return new SpecificData(this.currentSceneCollectionName, sceneCollections);
            }

            public String toString() {
                return "GetSceneCollectionListResponse.SpecificData.SpecificDataBuilder(currentSceneCollectionName=" + this.currentSceneCollectionName + ", sceneCollections=" + this.sceneCollections + ")";
            }
        }
    }
}

