/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response.config;

import io.obswebsocket.community.client.message.response.RequestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GetProfileListResponse
extends RequestResponse<SpecificData> {
    public String getCurrentProfileName() {
        return ((SpecificData)this.getMessageData().getResponseData()).getCurrentProfileName();
    }

    public List<String> getProfiles() {
        return ((SpecificData)this.getMessageData().getResponseData()).getProfiles();
    }

    @Override
    public String toString() {
        return "GetProfileListResponse(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private String currentProfileName;
        private List<String> profiles;

        SpecificData(String currentProfileName, List<String> profiles) {
            this.currentProfileName = currentProfileName;
            this.profiles = profiles;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public String getCurrentProfileName() {
            return this.currentProfileName;
        }

        public List<String> getProfiles() {
            return this.profiles;
        }

        public String toString() {
            return "GetProfileListResponse.SpecificData(currentProfileName=" + this.getCurrentProfileName() + ", profiles=" + this.getProfiles() + ")";
        }

        public static class SpecificDataBuilder {
            private String currentProfileName;
            private ArrayList<String> profiles;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder currentProfileName(String currentProfileName) {
                this.currentProfileName = currentProfileName;
                return this;
            }

            public SpecificDataBuilder profile(String profile) {
                if (this.profiles == null) {
                    this.profiles = new ArrayList();
                }
                this.profiles.add(profile);
                return this;
            }

            public SpecificDataBuilder profiles(Collection<? extends String> profiles) {
                if (profiles == null) {
                    throw new IllegalArgumentException("profiles cannot be null");
                }
                if (this.profiles == null) {
                    this.profiles = new ArrayList();
                }
                this.profiles.addAll(profiles);
                return this;
            }

            public SpecificDataBuilder clearProfiles() {
                if (this.profiles != null) {
                    this.profiles.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<String> profiles;
                switch (this.profiles == null ? 0 : this.profiles.size()) {
                    case 0: {
                        profiles = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        profiles = Collections.singletonList(this.profiles.get(0));
                        break;
                    }
                    default: {
                        profiles = Collections.unmodifiableList(new ArrayList<String>(this.profiles));
                    }
                }
                return new SpecificData(this.currentProfileName, profiles);
            }

            public String toString() {
                return "GetProfileListResponse.SpecificData.SpecificDataBuilder(currentProfileName=" + this.currentProfileName + ", profiles=" + this.profiles + ")";
            }
        }
    }
}

