/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response;

import com.google.gson.annotations.SerializedName;
import io.obswebsocket.community.client.message.Message;
import io.obswebsocket.community.client.message.request.Request;

public abstract class RequestResponse<T>
extends Message {
    @SerializedName(value="d")
    private Data<T> messageData;

    protected RequestResponse() {
        super(Message.OperationCode.RequestResponse);
    }

    public boolean isSuccessful() {
        return this.messageData.requestStatus != null && Boolean.TRUE.equals(this.messageData.requestStatus.result);
    }

    public Data<T> getMessageData() {
        return this.messageData;
    }

    @Override
    public String toString() {
        return "RequestResponse(super=" + super.toString() + ", messageData=" + this.getMessageData() + ")";
    }

    public static class Status {
        protected Boolean result;
        protected Integer code;
        protected String comment;

        Status(Boolean result, Integer code, String comment) {
            this.result = result;
            this.code = code;
            this.comment = comment;
        }

        public static StatusBuilder builder() {
            return new StatusBuilder();
        }

        public Boolean getResult() {
            return this.result;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getComment() {
            return this.comment;
        }

        public String toString() {
            return "RequestResponse.Status(result=" + this.getResult() + ", code=" + this.getCode() + ", comment=" + this.getComment() + ")";
        }

        public static class StatusBuilder {
            private Boolean result;
            private Integer code;
            private String comment;

            StatusBuilder() {
            }

            public StatusBuilder result(Boolean result) {
                this.result = result;
                return this;
            }

            public StatusBuilder code(Integer code) {
                this.code = code;
                return this;
            }

            public StatusBuilder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Status build() {
                return new Status(this.result, this.code, this.comment);
            }

            public String toString() {
                return "RequestResponse.Status.StatusBuilder(result=" + this.result + ", code=" + this.code + ", comment=" + this.comment + ")";
            }
        }

        static enum Code {
            Unknown(0),
            NoError(10),
            Success(100),
            MissingRequestType(203),
            UnknownRequestType(204),
            GenericError(205),
            MissingRequestParameter(300),
            MissingRequestData(301),
            InvalidRequestParameter(400),
            InvalidRequestParameterType(401),
            RequestParameterOutOfRange(402),
            RequestParameterEmpty(403),
            TooManyRequestParameters(404),
            OutputRunning(500),
            OutputNotRunning(501),
            OutputPaused(502),
            OutputDisabled(503),
            StudioModeActive(504),
            StudioModeNotActive(505),
            ResourceNotFound(600),
            ResourceAlreadyExists(601),
            InvalidResourceType(602),
            NotEnoughResources(603),
            InvalidResourceState(604),
            InvalidInputKind(605),
            ResourceCreationFailed(700),
            ResourceActionFailed(701),
            RequestProcessingFailed(702),
            CannotAct(703);

            private final int value;

            private Code(int value) {
                this.value = value;
            }
        }
    }

    public static class Data<T>
    extends Request.Data {
        protected Status requestStatus;
        private T responseData;

        protected Data(DataBuilder<T, ?, ?> b) {
            super(b);
            this.requestStatus = ((DataBuilder)b).requestStatus;
            this.responseData = ((DataBuilder)b).responseData;
        }

        public static <T> DataBuilder<T, ?, ?> builder() {
            return new DataBuilderImpl();
        }

        @Override
        public String toString() {
            return "RequestResponse.Data(super=" + super.toString() + ", requestStatus=" + this.getRequestStatus() + ", responseData=" + this.getResponseData() + ")";
        }

        public Status getRequestStatus() {
            return this.requestStatus;
        }

        public T getResponseData() {
            return this.responseData;
        }

        private static final class DataBuilderImpl<T>
        extends DataBuilder<T, Data<T>, DataBuilderImpl<T>> {
            private DataBuilderImpl() {
            }

            @Override
            protected DataBuilderImpl<T> self() {
                return this;
            }

            @Override
            public Data<T> build() {
                return new Data(this);
            }
        }

        public static abstract class DataBuilder<T, C extends Data<T>, B extends DataBuilder<T, C, B>>
        extends Request.Data.DataBuilder<C, B> {
            private Status requestStatus;
            private T responseData;

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            public B requestStatus(Status requestStatus) {
                this.requestStatus = requestStatus;
                return (B)this.self();
            }

            public B responseData(T responseData) {
                this.responseData = responseData;
                return (B)this.self();
            }

            @Override
            public String toString() {
                return "RequestResponse.Data.DataBuilder(super=" + super.toString() + ", requestStatus=" + this.requestStatus + ", responseData=" + this.responseData + ")";
            }
        }
    }
}

