/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.response;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.obswebsocket.community.client.message.request.RequestType;
import io.obswebsocket.community.client.message.response.RequestResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class RequestBatchResponseResultsDeserialization
implements JsonDeserializer<List<RequestResponse.Data>> {
    public List<RequestResponse.Data> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<RequestResponse.Data> requestResponse = null;
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArr = jsonElement.getAsJsonArray();
            requestResponse = new ArrayList<RequestResponse.Data>();
            for (int i = 0; i < jsonArr.size(); ++i) {
                JsonObject messageData;
                JsonElement arrElement = jsonArr.get(i);
                if (!arrElement.isJsonObject() || !(messageData = arrElement.getAsJsonObject()).has("requestType")) continue;
                RequestType requestType = null;
                try {
                    requestType = RequestType.valueOf(messageData.get("requestType").getAsString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (requestType == null) continue;
                try {
                    Type dataType = this.getSuperTypeParam(requestType.getRequestResponseClass());
                    Type typeToken = TypeToken.getParameterized(RequestResponse.Data.class, (Type[])new Type[]{dataType}).getType();
                    RequestResponse.Data data = (RequestResponse.Data)context.deserialize(arrElement, typeToken);
                    requestResponse.add(data);
                    continue;
                }
                catch (Throwable t) {
                    throw new JsonParseException(t);
                }
            }
        }
        return requestResponse;
    }

    private Type getSuperTypeParam(Class<?> cls) {
        Type parent = cls.getGenericSuperclass();
        if (parent instanceof ParameterizedType && ((ParameterizedType)parent).getActualTypeArguments().length > 0) {
            return ((ParameterizedType)parent).getActualTypeArguments()[0];
        }
        if (parent instanceof Class) {
            return this.getSuperTypeParam((Class)parent);
        }
        return null;
    }
}

