/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.ui;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import io.obswebsocket.community.client.model.VideoMixType;
import lombok.NonNull;

public class OpenVideoMixProjectorRequest
extends Request<SpecificData> {
    private OpenVideoMixProjectorRequest(VideoMixType videoMixType, Number monitorIndex, String projectorGeometry) {
        super(RequestType.OpenVideoMixProjector, SpecificData.builder().videoMixType(videoMixType).monitorIndex(monitorIndex).projectorGeometry(projectorGeometry).build());
    }

    public static OpenVideoMixProjectorRequestBuilder builder() {
        return new OpenVideoMixProjectorRequestBuilder();
    }

    @Override
    public String toString() {
        return "OpenVideoMixProjectorRequest(super=" + super.toString() + ")";
    }

    public static class OpenVideoMixProjectorRequestBuilder {
        private VideoMixType videoMixType;
        private Number monitorIndex;
        private String projectorGeometry;

        OpenVideoMixProjectorRequestBuilder() {
        }

        public OpenVideoMixProjectorRequestBuilder videoMixType(VideoMixType videoMixType) {
            this.videoMixType = videoMixType;
            return this;
        }

        public OpenVideoMixProjectorRequestBuilder monitorIndex(Number monitorIndex) {
            this.monitorIndex = monitorIndex;
            return this;
        }

        public OpenVideoMixProjectorRequestBuilder projectorGeometry(String projectorGeometry) {
            this.projectorGeometry = projectorGeometry;
            return this;
        }

        public OpenVideoMixProjectorRequest build() {
            return new OpenVideoMixProjectorRequest(this.videoMixType, this.monitorIndex, this.projectorGeometry);
        }

        public String toString() {
            return "OpenVideoMixProjectorRequest.OpenVideoMixProjectorRequestBuilder(videoMixType=" + (Object)((Object)this.videoMixType) + ", monitorIndex=" + this.monitorIndex + ", projectorGeometry=" + this.projectorGeometry + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private VideoMixType videoMixType;
        private Number monitorIndex;
        private String projectorGeometry;

        SpecificData(@NonNull VideoMixType videoMixType, Number monitorIndex, String projectorGeometry) {
            if (videoMixType == null) {
                throw new IllegalArgumentException("videoMixType is marked non-null but is null");
            }
            this.videoMixType = videoMixType;
            this.monitorIndex = monitorIndex;
            this.projectorGeometry = projectorGeometry;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public VideoMixType getVideoMixType() {
            return this.videoMixType;
        }

        public Number getMonitorIndex() {
            return this.monitorIndex;
        }

        public String getProjectorGeometry() {
            return this.projectorGeometry;
        }

        public String toString() {
            return "OpenVideoMixProjectorRequest.SpecificData(videoMixType=" + (Object)((Object)this.getVideoMixType()) + ", monitorIndex=" + this.getMonitorIndex() + ", projectorGeometry=" + this.getProjectorGeometry() + ")";
        }

        public static class SpecificDataBuilder {
            private VideoMixType videoMixType;
            private Number monitorIndex;
            private String projectorGeometry;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder videoMixType(@NonNull VideoMixType videoMixType) {
                if (videoMixType == null) {
                    throw new IllegalArgumentException("videoMixType is marked non-null but is null");
                }
                this.videoMixType = videoMixType;
                return this;
            }

            public SpecificDataBuilder monitorIndex(Number monitorIndex) {
                this.monitorIndex = monitorIndex;
                return this;
            }

            public SpecificDataBuilder projectorGeometry(String projectorGeometry) {
                this.projectorGeometry = projectorGeometry;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.videoMixType, this.monitorIndex, this.projectorGeometry);
            }

            public String toString() {
                return "OpenVideoMixProjectorRequest.SpecificData.SpecificDataBuilder(videoMixType=" + (Object)((Object)this.videoMixType) + ", monitorIndex=" + this.monitorIndex + ", projectorGeometry=" + this.projectorGeometry + ")";
            }
        }
    }
}

