/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.ui;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class OpenSourceProjectorRequest
extends Request<SpecificData> {
    private OpenSourceProjectorRequest(String sourceName, Number monitorIndex, String projectorGeometry) {
        super(RequestType.OpenSourceProjector, SpecificData.builder().sourceName(sourceName).monitorIndex(monitorIndex).projectorGeometry(projectorGeometry).build());
    }

    public static OpenSourceProjectorRequestBuilder builder() {
        return new OpenSourceProjectorRequestBuilder();
    }

    @Override
    public String toString() {
        return "OpenSourceProjectorRequest(super=" + super.toString() + ")";
    }

    public static class OpenSourceProjectorRequestBuilder {
        private String sourceName;
        private Number monitorIndex;
        private String projectorGeometry;

        OpenSourceProjectorRequestBuilder() {
        }

        public OpenSourceProjectorRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public OpenSourceProjectorRequestBuilder monitorIndex(Number monitorIndex) {
            this.monitorIndex = monitorIndex;
            return this;
        }

        public OpenSourceProjectorRequestBuilder projectorGeometry(String projectorGeometry) {
            this.projectorGeometry = projectorGeometry;
            return this;
        }

        public OpenSourceProjectorRequest build() {
            return new OpenSourceProjectorRequest(this.sourceName, this.monitorIndex, this.projectorGeometry);
        }

        public String toString() {
            return "OpenSourceProjectorRequest.OpenSourceProjectorRequestBuilder(sourceName=" + this.sourceName + ", monitorIndex=" + this.monitorIndex + ", projectorGeometry=" + this.projectorGeometry + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        private Number monitorIndex;
        private String projectorGeometry;

        SpecificData(@NonNull String sourceName, Number monitorIndex, String projectorGeometry) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.monitorIndex = monitorIndex;
            this.projectorGeometry = projectorGeometry;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        public Number getMonitorIndex() {
            return this.monitorIndex;
        }

        public String getProjectorGeometry() {
            return this.projectorGeometry;
        }

        public String toString() {
            return "OpenSourceProjectorRequest.SpecificData(sourceName=" + this.getSourceName() + ", monitorIndex=" + this.getMonitorIndex() + ", projectorGeometry=" + this.getProjectorGeometry() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private Number monitorIndex;
            private String projectorGeometry;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder monitorIndex(Number monitorIndex) {
                this.monitorIndex = monitorIndex;
                return this;
            }

            public SpecificDataBuilder projectorGeometry(String projectorGeometry) {
                this.projectorGeometry = projectorGeometry;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.monitorIndex, this.projectorGeometry);
            }

            public String toString() {
                return "OpenSourceProjectorRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", monitorIndex=" + this.monitorIndex + ", projectorGeometry=" + this.projectorGeometry + ")";
            }
        }
    }
}

