/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.transitions;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetTBarPositionRequest
extends Request<SpecificData> {
    private SetTBarPositionRequest(Number position, Boolean release) {
        super(RequestType.SetTBarPosition, SpecificData.builder().position(position).release(release).build());
    }

    public static SetTBarPositionRequestBuilder builder() {
        return new SetTBarPositionRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetTBarPositionRequest(super=" + super.toString() + ")";
    }

    public static class SetTBarPositionRequestBuilder {
        private Number position;
        private Boolean release;

        SetTBarPositionRequestBuilder() {
        }

        public SetTBarPositionRequestBuilder position(Number position) {
            this.position = position;
            return this;
        }

        public SetTBarPositionRequestBuilder release(Boolean release) {
            this.release = release;
            return this;
        }

        public SetTBarPositionRequest build() {
            return new SetTBarPositionRequest(this.position, this.release);
        }

        public String toString() {
            return "SetTBarPositionRequest.SetTBarPositionRequestBuilder(position=" + this.position + ", release=" + this.release + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private Number position;
        private Boolean release;

        SpecificData(@NonNull Number position, Boolean release) {
            if (position == null) {
                throw new IllegalArgumentException("position is marked non-null but is null");
            }
            this.position = position;
            this.release = release;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public Number getPosition() {
            return this.position;
        }

        public Boolean getRelease() {
            return this.release;
        }

        public String toString() {
            return "SetTBarPositionRequest.SpecificData(position=" + this.getPosition() + ", release=" + this.getRelease() + ")";
        }

        public static class SpecificDataBuilder {
            private Number position;
            private Boolean release;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder position(@NonNull Number position) {
                if (position == null) {
                    throw new IllegalArgumentException("position is marked non-null but is null");
                }
                this.position = position;
                return this;
            }

            public SpecificDataBuilder release(Boolean release) {
                this.release = release;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.position, this.release);
            }

            public String toString() {
                return "SetTBarPositionRequest.SpecificData.SpecificDataBuilder(position=" + this.position + ", release=" + this.release + ")";
            }
        }
    }
}

