/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.stream;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SendStreamCaptionRequest
extends Request<SpecificData> {
    private SendStreamCaptionRequest(String captionText) {
        super(RequestType.SendStreamCaption, SpecificData.builder().captionText(captionText).build());
    }

    public static SendStreamCaptionRequestBuilder builder() {
        return new SendStreamCaptionRequestBuilder();
    }

    @Override
    public String toString() {
        return "SendStreamCaptionRequest(super=" + super.toString() + ")";
    }

    public static class SendStreamCaptionRequestBuilder {
        private String captionText;

        SendStreamCaptionRequestBuilder() {
        }

        public SendStreamCaptionRequestBuilder captionText(String captionText) {
            this.captionText = captionText;
            return this;
        }

        public SendStreamCaptionRequest build() {
            return new SendStreamCaptionRequest(this.captionText);
        }

        public String toString() {
            return "SendStreamCaptionRequest.SendStreamCaptionRequestBuilder(captionText=" + this.captionText + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String captionText;

        SpecificData(@NonNull String captionText) {
            if (captionText == null) {
                throw new IllegalArgumentException("captionText is marked non-null but is null");
            }
            this.captionText = captionText;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getCaptionText() {
            return this.captionText;
        }

        public String toString() {
            return "SendStreamCaptionRequest.SpecificData(captionText=" + this.getCaptionText() + ")";
        }

        public static class SpecificDataBuilder {
            private String captionText;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder captionText(@NonNull String captionText) {
                if (captionText == null) {
                    throw new IllegalArgumentException("captionText is marked non-null but is null");
                }
                this.captionText = captionText;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.captionText);
            }

            public String toString() {
                return "SendStreamCaptionRequest.SpecificData.SpecificDataBuilder(captionText=" + this.captionText + ")";
            }
        }
    }
}

