/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sources;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SaveSourceScreenshotRequest
extends Request<SpecificData> {
    private SaveSourceScreenshotRequest(String sourceName, String imageFormat, String imageFilePath, Number imageWidth, Number imageHeight, Number imageCompressionQuality) {
        super(RequestType.SaveSourceScreenshot, SpecificData.builder().sourceName(sourceName).imageFormat(imageFormat).imageFilePath(imageFilePath).imageWidth(imageWidth).imageHeight(imageHeight).imageCompressionQuality(imageCompressionQuality).build());
    }

    public static SaveSourceScreenshotRequestBuilder builder() {
        return new SaveSourceScreenshotRequestBuilder();
    }

    @Override
    public String toString() {
        return "SaveSourceScreenshotRequest(super=" + super.toString() + ")";
    }

    public static class SaveSourceScreenshotRequestBuilder {
        private String sourceName;
        private String imageFormat;
        private String imageFilePath;
        private Number imageWidth;
        private Number imageHeight;
        private Number imageCompressionQuality;

        SaveSourceScreenshotRequestBuilder() {
        }

        public SaveSourceScreenshotRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public SaveSourceScreenshotRequestBuilder imageFormat(String imageFormat) {
            this.imageFormat = imageFormat;
            return this;
        }

        public SaveSourceScreenshotRequestBuilder imageFilePath(String imageFilePath) {
            this.imageFilePath = imageFilePath;
            return this;
        }

        public SaveSourceScreenshotRequestBuilder imageWidth(Number imageWidth) {
            this.imageWidth = imageWidth;
            return this;
        }

        public SaveSourceScreenshotRequestBuilder imageHeight(Number imageHeight) {
            this.imageHeight = imageHeight;
            return this;
        }

        public SaveSourceScreenshotRequestBuilder imageCompressionQuality(Number imageCompressionQuality) {
            this.imageCompressionQuality = imageCompressionQuality;
            return this;
        }

        public SaveSourceScreenshotRequest build() {
            return new SaveSourceScreenshotRequest(this.sourceName, this.imageFormat, this.imageFilePath, this.imageWidth, this.imageHeight, this.imageCompressionQuality);
        }

        public String toString() {
            return "SaveSourceScreenshotRequest.SaveSourceScreenshotRequestBuilder(sourceName=" + this.sourceName + ", imageFormat=" + this.imageFormat + ", imageFilePath=" + this.imageFilePath + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", imageCompressionQuality=" + this.imageCompressionQuality + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        @NonNull
        private String imageFormat;
        @NonNull
        private String imageFilePath;
        private Number imageWidth;
        private Number imageHeight;
        private Number imageCompressionQuality;

        SpecificData(@NonNull String sourceName, @NonNull String imageFormat, @NonNull String imageFilePath, Number imageWidth, Number imageHeight, Number imageCompressionQuality) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            if (imageFormat == null) {
                throw new IllegalArgumentException("imageFormat is marked non-null but is null");
            }
            if (imageFilePath == null) {
                throw new IllegalArgumentException("imageFilePath is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.imageFormat = imageFormat;
            this.imageFilePath = imageFilePath;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.imageCompressionQuality = imageCompressionQuality;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        @NonNull
        public String getImageFormat() {
            return this.imageFormat;
        }

        @NonNull
        public String getImageFilePath() {
            return this.imageFilePath;
        }

        public Number getImageWidth() {
            return this.imageWidth;
        }

        public Number getImageHeight() {
            return this.imageHeight;
        }

        public Number getImageCompressionQuality() {
            return this.imageCompressionQuality;
        }

        public String toString() {
            return "SaveSourceScreenshotRequest.SpecificData(sourceName=" + this.getSourceName() + ", imageFormat=" + this.getImageFormat() + ", imageFilePath=" + this.getImageFilePath() + ", imageWidth=" + this.getImageWidth() + ", imageHeight=" + this.getImageHeight() + ", imageCompressionQuality=" + this.getImageCompressionQuality() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String imageFormat;
            private String imageFilePath;
            private Number imageWidth;
            private Number imageHeight;
            private Number imageCompressionQuality;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder imageFormat(@NonNull String imageFormat) {
                if (imageFormat == null) {
                    throw new IllegalArgumentException("imageFormat is marked non-null but is null");
                }
                this.imageFormat = imageFormat;
                return this;
            }

            public SpecificDataBuilder imageFilePath(@NonNull String imageFilePath) {
                if (imageFilePath == null) {
                    throw new IllegalArgumentException("imageFilePath is marked non-null but is null");
                }
                this.imageFilePath = imageFilePath;
                return this;
            }

            public SpecificDataBuilder imageWidth(Number imageWidth) {
                this.imageWidth = imageWidth;
                return this;
            }

            public SpecificDataBuilder imageHeight(Number imageHeight) {
                this.imageHeight = imageHeight;
                return this;
            }

            public SpecificDataBuilder imageCompressionQuality(Number imageCompressionQuality) {
                this.imageCompressionQuality = imageCompressionQuality;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.imageFormat, this.imageFilePath, this.imageWidth, this.imageHeight, this.imageCompressionQuality);
            }

            public String toString() {
                return "SaveSourceScreenshotRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", imageFormat=" + this.imageFormat + ", imageFilePath=" + this.imageFilePath + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", imageCompressionQuality=" + this.imageCompressionQuality + ")";
            }
        }
    }
}

