/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sources;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class GetSourceScreenshotRequest
extends Request<SpecificData> {
    private GetSourceScreenshotRequest(String sourceName, String imageFormat, Number imageWidth, Number imageHeight, Number imageCompressionQuality) {
        super(RequestType.GetSourceScreenshot, SpecificData.builder().sourceName(sourceName).imageFormat(imageFormat).imageWidth(imageWidth).imageHeight(imageHeight).imageCompressionQuality(imageCompressionQuality).build());
    }

    public static GetSourceScreenshotRequestBuilder builder() {
        return new GetSourceScreenshotRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetSourceScreenshotRequest(super=" + super.toString() + ")";
    }

    public static class GetSourceScreenshotRequestBuilder {
        private String sourceName;
        private String imageFormat;
        private Number imageWidth;
        private Number imageHeight;
        private Number imageCompressionQuality;

        GetSourceScreenshotRequestBuilder() {
        }

        public GetSourceScreenshotRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public GetSourceScreenshotRequestBuilder imageFormat(String imageFormat) {
            this.imageFormat = imageFormat;
            return this;
        }

        public GetSourceScreenshotRequestBuilder imageWidth(Number imageWidth) {
            this.imageWidth = imageWidth;
            return this;
        }

        public GetSourceScreenshotRequestBuilder imageHeight(Number imageHeight) {
            this.imageHeight = imageHeight;
            return this;
        }

        public GetSourceScreenshotRequestBuilder imageCompressionQuality(Number imageCompressionQuality) {
            this.imageCompressionQuality = imageCompressionQuality;
            return this;
        }

        public GetSourceScreenshotRequest build() {
            return new GetSourceScreenshotRequest(this.sourceName, this.imageFormat, this.imageWidth, this.imageHeight, this.imageCompressionQuality);
        }

        public String toString() {
            return "GetSourceScreenshotRequest.GetSourceScreenshotRequestBuilder(sourceName=" + this.sourceName + ", imageFormat=" + this.imageFormat + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", imageCompressionQuality=" + this.imageCompressionQuality + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        @NonNull
        private String imageFormat;
        private Number imageWidth;
        private Number imageHeight;
        private Number imageCompressionQuality;

        SpecificData(@NonNull String sourceName, @NonNull String imageFormat, Number imageWidth, Number imageHeight, Number imageCompressionQuality) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            if (imageFormat == null) {
                throw new IllegalArgumentException("imageFormat is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.imageFormat = imageFormat;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.imageCompressionQuality = imageCompressionQuality;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        @NonNull
        public String getImageFormat() {
            return this.imageFormat;
        }

        public Number getImageWidth() {
            return this.imageWidth;
        }

        public Number getImageHeight() {
            return this.imageHeight;
        }

        public Number getImageCompressionQuality() {
            return this.imageCompressionQuality;
        }

        public String toString() {
            return "GetSourceScreenshotRequest.SpecificData(sourceName=" + this.getSourceName() + ", imageFormat=" + this.getImageFormat() + ", imageWidth=" + this.getImageWidth() + ", imageHeight=" + this.getImageHeight() + ", imageCompressionQuality=" + this.getImageCompressionQuality() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String imageFormat;
            private Number imageWidth;
            private Number imageHeight;
            private Number imageCompressionQuality;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder imageFormat(@NonNull String imageFormat) {
                if (imageFormat == null) {
                    throw new IllegalArgumentException("imageFormat is marked non-null but is null");
                }
                this.imageFormat = imageFormat;
                return this;
            }

            public SpecificDataBuilder imageWidth(Number imageWidth) {
                this.imageWidth = imageWidth;
                return this;
            }

            public SpecificDataBuilder imageHeight(Number imageHeight) {
                this.imageHeight = imageHeight;
                return this;
            }

            public SpecificDataBuilder imageCompressionQuality(Number imageCompressionQuality) {
                this.imageCompressionQuality = imageCompressionQuality;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.imageFormat, this.imageWidth, this.imageHeight, this.imageCompressionQuality);
            }

            public String toString() {
                return "GetSourceScreenshotRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", imageFormat=" + this.imageFormat + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", imageCompressionQuality=" + this.imageCompressionQuality + ")";
            }
        }
    }
}

