/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.scenes;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetSceneNameRequest
extends Request<SpecificData> {
    private SetSceneNameRequest(String sceneName, String newSceneName) {
        super(RequestType.SetSceneName, SpecificData.builder().sceneName(sceneName).newSceneName(newSceneName).build());
    }

    public static SetSceneNameRequestBuilder builder() {
        return new SetSceneNameRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetSceneNameRequest(super=" + super.toString() + ")";
    }

    public static class SetSceneNameRequestBuilder {
        private String sceneName;
        private String newSceneName;

        SetSceneNameRequestBuilder() {
        }

        public SetSceneNameRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public SetSceneNameRequestBuilder newSceneName(String newSceneName) {
            this.newSceneName = newSceneName;
            return this;
        }

        public SetSceneNameRequest build() {
            return new SetSceneNameRequest(this.sceneName, this.newSceneName);
        }

        public String toString() {
            return "SetSceneNameRequest.SetSceneNameRequestBuilder(sceneName=" + this.sceneName + ", newSceneName=" + this.newSceneName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private String newSceneName;

        SpecificData(@NonNull String sceneName, @NonNull String newSceneName) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (newSceneName == null) {
                throw new IllegalArgumentException("newSceneName is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.newSceneName = newSceneName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public String getNewSceneName() {
            return this.newSceneName;
        }

        public String toString() {
            return "SetSceneNameRequest.SpecificData(sceneName=" + this.getSceneName() + ", newSceneName=" + this.getNewSceneName() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private String newSceneName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder newSceneName(@NonNull String newSceneName) {
                if (newSceneName == null) {
                    throw new IllegalArgumentException("newSceneName is marked non-null but is null");
                }
                this.newSceneName = newSceneName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.newSceneName);
            }

            public String toString() {
                return "SetSceneNameRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", newSceneName=" + this.newSceneName + ")";
            }
        }
    }
}

