/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.scenes;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class RemoveSceneRequest
extends Request<SpecificData> {
    private RemoveSceneRequest(String sceneName) {
        super(RequestType.RemoveScene, SpecificData.builder().sceneName(sceneName).build());
    }

    public static RemoveSceneRequestBuilder builder() {
        return new RemoveSceneRequestBuilder();
    }

    @Override
    public String toString() {
        return "RemoveSceneRequest(super=" + super.toString() + ")";
    }

    public static class RemoveSceneRequestBuilder {
        private String sceneName;

        RemoveSceneRequestBuilder() {
        }

        public RemoveSceneRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public RemoveSceneRequest build() {
            return new RemoveSceneRequest(this.sceneName);
        }

        public String toString() {
            return "RemoveSceneRequest.RemoveSceneRequestBuilder(sceneName=" + this.sceneName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;

        SpecificData(@NonNull String sceneName) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            this.sceneName = sceneName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        public String toString() {
            return "RemoveSceneRequest.SpecificData(sceneName=" + this.getSceneName() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName);
            }

            public String toString() {
                return "RemoveSceneRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ")";
            }
        }
    }
}

