/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.scenes;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class CreateSceneRequest
extends Request<SpecificData> {
    private CreateSceneRequest(String sceneName) {
        super(RequestType.CreateScene, SpecificData.builder().sceneName(sceneName).build());
    }

    public static CreateSceneRequestBuilder builder() {
        return new CreateSceneRequestBuilder();
    }

    @Override
    public String toString() {
        return "CreateSceneRequest(super=" + super.toString() + ")";
    }

    public static class CreateSceneRequestBuilder {
        private String sceneName;

        CreateSceneRequestBuilder() {
        }

        public CreateSceneRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public CreateSceneRequest build() {
            return new CreateSceneRequest(this.sceneName);
        }

        public String toString() {
            return "CreateSceneRequest.CreateSceneRequestBuilder(sceneName=" + this.sceneName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;

        SpecificData(@NonNull String sceneName) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            this.sceneName = sceneName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        public String toString() {
            return "CreateSceneRequest.SpecificData(sceneName=" + this.getSceneName() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName);
            }

            public String toString() {
                return "CreateSceneRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ")";
            }
        }
    }
}

