/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import io.obswebsocket.community.client.model.SceneItem;
import lombok.NonNull;

public class SetSceneItemTransformRequest
extends Request<SpecificData> {
    private SetSceneItemTransformRequest(String sceneName, Number sceneItemId, SceneItem.Transform sceneItemTransform) {
        super(RequestType.SetSceneItemTransform, SpecificData.builder().sceneName(sceneName).sceneItemId(sceneItemId).sceneItemTransform(sceneItemTransform).build());
    }

    public static SetSceneItemTransformRequestBuilder builder() {
        return new SetSceneItemTransformRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetSceneItemTransformRequest(super=" + super.toString() + ")";
    }

    public static class SetSceneItemTransformRequestBuilder {
        private String sceneName;
        private Number sceneItemId;
        private SceneItem.Transform sceneItemTransform;

        SetSceneItemTransformRequestBuilder() {
        }

        public SetSceneItemTransformRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public SetSceneItemTransformRequestBuilder sceneItemId(Number sceneItemId) {
            this.sceneItemId = sceneItemId;
            return this;
        }

        public SetSceneItemTransformRequestBuilder sceneItemTransform(SceneItem.Transform sceneItemTransform) {
            this.sceneItemTransform = sceneItemTransform;
            return this;
        }

        public SetSceneItemTransformRequest build() {
            return new SetSceneItemTransformRequest(this.sceneName, this.sceneItemId, this.sceneItemTransform);
        }

        public String toString() {
            return "SetSceneItemTransformRequest.SetSceneItemTransformRequestBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ", sceneItemTransform=" + this.sceneItemTransform + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private Number sceneItemId;
        @NonNull
        private SceneItem.Transform sceneItemTransform;

        SpecificData(@NonNull String sceneName, @NonNull Number sceneItemId, @NonNull SceneItem.Transform sceneItemTransform) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (sceneItemId == null) {
                throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
            }
            if (sceneItemTransform == null) {
                throw new IllegalArgumentException("sceneItemTransform is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.sceneItemId = sceneItemId;
            this.sceneItemTransform = sceneItemTransform;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public Number getSceneItemId() {
            return this.sceneItemId;
        }

        @NonNull
        public SceneItem.Transform getSceneItemTransform() {
            return this.sceneItemTransform;
        }

        public String toString() {
            return "SetSceneItemTransformRequest.SpecificData(sceneName=" + this.getSceneName() + ", sceneItemId=" + this.getSceneItemId() + ", sceneItemTransform=" + this.getSceneItemTransform() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private Number sceneItemId;
            private SceneItem.Transform sceneItemTransform;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sceneItemId(@NonNull Number sceneItemId) {
                if (sceneItemId == null) {
                    throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
                }
                this.sceneItemId = sceneItemId;
                return this;
            }

            public SpecificDataBuilder sceneItemTransform(@NonNull SceneItem.Transform sceneItemTransform) {
                if (sceneItemTransform == null) {
                    throw new IllegalArgumentException("sceneItemTransform is marked non-null but is null");
                }
                this.sceneItemTransform = sceneItemTransform;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.sceneItemId, this.sceneItemTransform);
            }

            public String toString() {
                return "SetSceneItemTransformRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ", sceneItemTransform=" + this.sceneItemTransform + ")";
            }
        }
    }
}

