/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetSceneItemIndexRequest
extends Request<SpecificData> {
    private SetSceneItemIndexRequest(String sceneName, Number sceneItemId, Number sceneItemIndex) {
        super(RequestType.SetSceneItemIndex, SpecificData.builder().sceneName(sceneName).sceneItemId(sceneItemId).sceneItemIndex(sceneItemIndex).build());
    }

    public static SetSceneItemIndexRequestBuilder builder() {
        return new SetSceneItemIndexRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetSceneItemIndexRequest(super=" + super.toString() + ")";
    }

    public static class SetSceneItemIndexRequestBuilder {
        private String sceneName;
        private Number sceneItemId;
        private Number sceneItemIndex;

        SetSceneItemIndexRequestBuilder() {
        }

        public SetSceneItemIndexRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public SetSceneItemIndexRequestBuilder sceneItemId(Number sceneItemId) {
            this.sceneItemId = sceneItemId;
            return this;
        }

        public SetSceneItemIndexRequestBuilder sceneItemIndex(Number sceneItemIndex) {
            this.sceneItemIndex = sceneItemIndex;
            return this;
        }

        public SetSceneItemIndexRequest build() {
            return new SetSceneItemIndexRequest(this.sceneName, this.sceneItemId, this.sceneItemIndex);
        }

        public String toString() {
            return "SetSceneItemIndexRequest.SetSceneItemIndexRequestBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ", sceneItemIndex=" + this.sceneItemIndex + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private Number sceneItemId;
        @NonNull
        private Number sceneItemIndex;

        SpecificData(@NonNull String sceneName, @NonNull Number sceneItemId, @NonNull Number sceneItemIndex) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (sceneItemId == null) {
                throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
            }
            if (sceneItemIndex == null) {
                throw new IllegalArgumentException("sceneItemIndex is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.sceneItemId = sceneItemId;
            this.sceneItemIndex = sceneItemIndex;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public Number getSceneItemId() {
            return this.sceneItemId;
        }

        @NonNull
        public Number getSceneItemIndex() {
            return this.sceneItemIndex;
        }

        public String toString() {
            return "SetSceneItemIndexRequest.SpecificData(sceneName=" + this.getSceneName() + ", sceneItemId=" + this.getSceneItemId() + ", sceneItemIndex=" + this.getSceneItemIndex() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private Number sceneItemId;
            private Number sceneItemIndex;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sceneItemId(@NonNull Number sceneItemId) {
                if (sceneItemId == null) {
                    throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
                }
                this.sceneItemId = sceneItemId;
                return this;
            }

            public SpecificDataBuilder sceneItemIndex(@NonNull Number sceneItemIndex) {
                if (sceneItemIndex == null) {
                    throw new IllegalArgumentException("sceneItemIndex is marked non-null but is null");
                }
                this.sceneItemIndex = sceneItemIndex;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.sceneItemId, this.sceneItemIndex);
            }

            public String toString() {
                return "SetSceneItemIndexRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ", sceneItemIndex=" + this.sceneItemIndex + ")";
            }
        }
    }
}

