/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import io.obswebsocket.community.client.model.SceneItem;
import lombok.NonNull;

public class SetSceneItemBlendModeRequest
extends Request<SpecificData> {
    private SetSceneItemBlendModeRequest(String sceneName, Number sceneItemId, SceneItem.BlendMode sceneItemBlendMode) {
        super(RequestType.SetSceneItemBlendMode, SpecificData.builder().sceneName(sceneName).sceneItemId(sceneItemId).sceneItemBlendMode(sceneItemBlendMode).build());
    }

    public static SetSceneItemBlendModeRequestBuilder builder() {
        return new SetSceneItemBlendModeRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetSceneItemBlendModeRequest(super=" + super.toString() + ")";
    }

    public static class SetSceneItemBlendModeRequestBuilder {
        private String sceneName;
        private Number sceneItemId;
        private SceneItem.BlendMode sceneItemBlendMode;

        SetSceneItemBlendModeRequestBuilder() {
        }

        public SetSceneItemBlendModeRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public SetSceneItemBlendModeRequestBuilder sceneItemId(Number sceneItemId) {
            this.sceneItemId = sceneItemId;
            return this;
        }

        public SetSceneItemBlendModeRequestBuilder sceneItemBlendMode(SceneItem.BlendMode sceneItemBlendMode) {
            this.sceneItemBlendMode = sceneItemBlendMode;
            return this;
        }

        public SetSceneItemBlendModeRequest build() {
            return new SetSceneItemBlendModeRequest(this.sceneName, this.sceneItemId, this.sceneItemBlendMode);
        }

        public String toString() {
            return "SetSceneItemBlendModeRequest.SetSceneItemBlendModeRequestBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ", sceneItemBlendMode=" + (Object)((Object)this.sceneItemBlendMode) + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private Number sceneItemId;
        @NonNull
        private SceneItem.BlendMode sceneItemBlendMode;

        SpecificData(@NonNull String sceneName, @NonNull Number sceneItemId, @NonNull SceneItem.BlendMode sceneItemBlendMode) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (sceneItemId == null) {
                throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
            }
            if (sceneItemBlendMode == null) {
                throw new IllegalArgumentException("sceneItemBlendMode is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.sceneItemId = sceneItemId;
            this.sceneItemBlendMode = sceneItemBlendMode;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public Number getSceneItemId() {
            return this.sceneItemId;
        }

        @NonNull
        public SceneItem.BlendMode getSceneItemBlendMode() {
            return this.sceneItemBlendMode;
        }

        public String toString() {
            return "SetSceneItemBlendModeRequest.SpecificData(sceneName=" + this.getSceneName() + ", sceneItemId=" + this.getSceneItemId() + ", sceneItemBlendMode=" + (Object)((Object)this.getSceneItemBlendMode()) + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private Number sceneItemId;
            private SceneItem.BlendMode sceneItemBlendMode;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sceneItemId(@NonNull Number sceneItemId) {
                if (sceneItemId == null) {
                    throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
                }
                this.sceneItemId = sceneItemId;
                return this;
            }

            public SpecificDataBuilder sceneItemBlendMode(@NonNull SceneItem.BlendMode sceneItemBlendMode) {
                if (sceneItemBlendMode == null) {
                    throw new IllegalArgumentException("sceneItemBlendMode is marked non-null but is null");
                }
                this.sceneItemBlendMode = sceneItemBlendMode;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.sceneItemId, this.sceneItemBlendMode);
            }

            public String toString() {
                return "SetSceneItemBlendModeRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ", sceneItemBlendMode=" + (Object)((Object)this.sceneItemBlendMode) + ")";
            }
        }
    }
}

