/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class GetSceneItemLockedRequest
extends Request<SpecificData> {
    private GetSceneItemLockedRequest(String sceneName, Number sceneItemId) {
        super(RequestType.GetSceneItemLocked, SpecificData.builder().sceneName(sceneName).sceneItemId(sceneItemId).build());
    }

    public static GetSceneItemLockedRequestBuilder builder() {
        return new GetSceneItemLockedRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetSceneItemLockedRequest(super=" + super.toString() + ")";
    }

    public static class GetSceneItemLockedRequestBuilder {
        private String sceneName;
        private Number sceneItemId;

        GetSceneItemLockedRequestBuilder() {
        }

        public GetSceneItemLockedRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public GetSceneItemLockedRequestBuilder sceneItemId(Number sceneItemId) {
            this.sceneItemId = sceneItemId;
            return this;
        }

        public GetSceneItemLockedRequest build() {
            return new GetSceneItemLockedRequest(this.sceneName, this.sceneItemId);
        }

        public String toString() {
            return "GetSceneItemLockedRequest.GetSceneItemLockedRequestBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private Number sceneItemId;

        SpecificData(@NonNull String sceneName, @NonNull Number sceneItemId) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (sceneItemId == null) {
                throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.sceneItemId = sceneItemId;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public Number getSceneItemId() {
            return this.sceneItemId;
        }

        public String toString() {
            return "GetSceneItemLockedRequest.SpecificData(sceneName=" + this.getSceneName() + ", sceneItemId=" + this.getSceneItemId() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private Number sceneItemId;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sceneItemId(@NonNull Number sceneItemId) {
                if (sceneItemId == null) {
                    throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
                }
                this.sceneItemId = sceneItemId;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.sceneItemId);
            }

            public String toString() {
                return "GetSceneItemLockedRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ")";
            }
        }
    }
}

