/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class GetSceneItemListRequest
extends Request<SpecificData> {
    private GetSceneItemListRequest(String sceneName) {
        super(RequestType.GetSceneItemList, SpecificData.builder().sceneName(sceneName).build());
    }

    public static GetSceneItemListRequestBuilder builder() {
        return new GetSceneItemListRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetSceneItemListRequest(super=" + super.toString() + ")";
    }

    public static class GetSceneItemListRequestBuilder {
        private String sceneName;

        GetSceneItemListRequestBuilder() {
        }

        public GetSceneItemListRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public GetSceneItemListRequest build() {
            return new GetSceneItemListRequest(this.sceneName);
        }

        public String toString() {
            return "GetSceneItemListRequest.GetSceneItemListRequestBuilder(sceneName=" + this.sceneName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;

        SpecificData(@NonNull String sceneName) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            this.sceneName = sceneName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        public String toString() {
            return "GetSceneItemListRequest.SpecificData(sceneName=" + this.getSceneName() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName);
            }

            public String toString() {
                return "GetSceneItemListRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ")";
            }
        }
    }
}

