/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class GetSceneItemIndexRequest
extends Request<SpecificData> {
    private GetSceneItemIndexRequest(String sceneName, Number sceneItemId) {
        super(RequestType.GetSceneItemIndex, SpecificData.builder().sceneName(sceneName).sceneItemId(sceneItemId).build());
    }

    public static GetSceneItemIndexRequestBuilder builder() {
        return new GetSceneItemIndexRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetSceneItemIndexRequest(super=" + super.toString() + ")";
    }

    public static class GetSceneItemIndexRequestBuilder {
        private String sceneName;
        private Number sceneItemId;

        GetSceneItemIndexRequestBuilder() {
        }

        public GetSceneItemIndexRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public GetSceneItemIndexRequestBuilder sceneItemId(Number sceneItemId) {
            this.sceneItemId = sceneItemId;
            return this;
        }

        public GetSceneItemIndexRequest build() {
            return new GetSceneItemIndexRequest(this.sceneName, this.sceneItemId);
        }

        public String toString() {
            return "GetSceneItemIndexRequest.GetSceneItemIndexRequestBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private Number sceneItemId;

        SpecificData(@NonNull String sceneName, @NonNull Number sceneItemId) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (sceneItemId == null) {
                throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.sceneItemId = sceneItemId;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public Number getSceneItemId() {
            return this.sceneItemId;
        }

        public String toString() {
            return "GetSceneItemIndexRequest.SpecificData(sceneName=" + this.getSceneName() + ", sceneItemId=" + this.getSceneItemId() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private Number sceneItemId;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sceneItemId(@NonNull Number sceneItemId) {
                if (sceneItemId == null) {
                    throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
                }
                this.sceneItemId = sceneItemId;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.sceneItemId);
            }

            public String toString() {
                return "GetSceneItemIndexRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ")";
            }
        }
    }
}

