/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class GetSceneItemIdRequest
extends Request<SpecificData> {
    private GetSceneItemIdRequest(String sceneName, String sourceName, Number searchOffset) {
        super(RequestType.GetSceneItemId, SpecificData.builder().sceneName(sceneName).sourceName(sourceName).searchOffset(searchOffset).build());
    }

    public static GetSceneItemIdRequestBuilder builder() {
        return new GetSceneItemIdRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetSceneItemIdRequest(super=" + super.toString() + ")";
    }

    public static class GetSceneItemIdRequestBuilder {
        private String sceneName;
        private String sourceName;
        private Number searchOffset;

        GetSceneItemIdRequestBuilder() {
        }

        public GetSceneItemIdRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public GetSceneItemIdRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public GetSceneItemIdRequestBuilder searchOffset(Number searchOffset) {
            this.searchOffset = searchOffset;
            return this;
        }

        public GetSceneItemIdRequest build() {
            return new GetSceneItemIdRequest(this.sceneName, this.sourceName, this.searchOffset);
        }

        public String toString() {
            return "GetSceneItemIdRequest.GetSceneItemIdRequestBuilder(sceneName=" + this.sceneName + ", sourceName=" + this.sourceName + ", searchOffset=" + this.searchOffset + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private String sourceName;
        private Number searchOffset;

        SpecificData(@NonNull String sceneName, @NonNull String sourceName, Number searchOffset) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.sourceName = sourceName;
            this.searchOffset = searchOffset;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        public Number getSearchOffset() {
            return this.searchOffset;
        }

        public String toString() {
            return "GetSceneItemIdRequest.SpecificData(sceneName=" + this.getSceneName() + ", sourceName=" + this.getSourceName() + ", searchOffset=" + this.getSearchOffset() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private String sourceName;
            private Number searchOffset;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder searchOffset(Number searchOffset) {
                this.searchOffset = searchOffset;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.sourceName, this.searchOffset);
            }

            public String toString() {
                return "GetSceneItemIdRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sourceName=" + this.sourceName + ", searchOffset=" + this.searchOffset + ")";
            }
        }
    }
}

